/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.List;
import opendap.dap.Attribute;
import opendap.dap.AttributeTable;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DConnect;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvAccess;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.cataloggen.config.DatasetNamerType;

public class DatasetNamer {
    private static Logger logger = LoggerFactory.getLogger(DatasetNamer.class);
    private InvDataset parentDataset = null;
    private String name = null;
    private boolean addLevel = false;
    private DatasetNamerType type = null;
    private String matchPattern = null;
    private String substitutePattern = null;
    private String attribContainer = null;
    private String attribName = null;
    private boolean isValid = true;
    private StringBuffer msgLog = new StringBuffer();

    public DatasetNamer(InvDataset parentDs, String name, String addLevelBoolean, String typeName, String matchPattern, String substitutePattern, String attribContainer, String attribName) {
        this(parentDs, name, new Boolean(addLevelBoolean), DatasetNamerType.getType(typeName), matchPattern, substitutePattern, attribContainer, attribName);
        if (this.getType() == null) {
            this.isValid = false;
            this.msgLog.append(" ** DatasetNamer (1): invalid type =(" + typeName + ") for datasetNamer (" + name + ")");
        }
    }

    public DatasetNamer(InvDataset parentDs, String name, boolean addLevel, DatasetNamerType type, String matchPattern, String substitutePattern, String attribContainer, String attribName) {
        this.parentDataset = parentDs;
        this.name = name;
        this.addLevel = addLevel;
        this.type = type;
        this.matchPattern = matchPattern;
        this.substitutePattern = substitutePattern;
        this.attribContainer = attribContainer;
        this.attribName = attribName;
    }

    public InvDataset getParentDataset() {
        return this.parentDataset;
    }

    public void setParentDataset(InvDataset parentDataset) {
        this.parentDataset = parentDataset;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getAddLevel() {
        return this.addLevel;
    }

    public void setAddLevel(boolean addLevel) {
        this.addLevel = addLevel;
    }

    public DatasetNamerType getType() {
        return this.type;
    }

    public void setType(String typeName) {
        this.type = DatasetNamerType.getType(typeName);
        if (this.getType() == null) {
            this.isValid = false;
            this.msgLog.append(" ** DatasetNamer (2): invalid type =(" + typeName + ") for datasetNamer (" + this.name + ")");
        }
    }

    public void setType(DatasetNamerType type) {
        this.type = type;
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public void setMatchPattern(String mPat) {
        this.matchPattern = mPat;
    }

    public String getSubstitutePattern() {
        return this.substitutePattern;
    }

    public void setSubstitutePattern(String sPat) {
        this.substitutePattern = sPat;
    }

    public String getAttribContainer() {
        return this.attribContainer;
    }

    public void setAttribContainer(String attContainer) {
        this.attribContainer = attContainer;
    }

    public String getAttribName() {
        return this.attribName;
    }

    public void setAttribName(String attName) {
        this.attribName = attName;
    }

    boolean validate(StringBuffer out) {
        this.isValid = true;
        if (this.msgLog.length() > 0) {
            out.append(this.msgLog);
        }
        if (this.getName() == null) {
            this.isValid = false;
            out.append(" ** DatasetNamer (1): null value for name is not valid.");
        }
        if (this.getType() == null) {
            this.isValid = false;
            out.append(" ** DatasetNamer (3): null value for type is not valid (set with bad string?).");
        }
        if (this.getType() == DatasetNamerType.REGULAR_EXPRESSION && (this.getMatchPattern() == null || this.getSubstitutePattern() == null || this.getAttribContainer() != null || this.getAttribName() != null)) {
            this.isValid = false;
            out.append(" ** DatasetNamer (4): invalid datasetNamer <" + this.getName() + ">;" + " type is " + this.getType().toString() + ": matchPattern(" + this.getMatchPattern() + ") and substitutionPattern(" + this.getSubstitutePattern() + ") " + "must not be null and attriuteContainer(" + this.getAttribContainer() + ") and attributeName(" + this.getAttribName() + ") must be null.");
        }
        if (this.getType() == DatasetNamerType.DODS_ATTRIBUTE && (this.getMatchPattern() != null || this.getSubstitutePattern() != null || this.getAttribContainer() == null || this.getAttribName() == null)) {
            this.isValid = false;
            out.append(" ** DatasetNamer (5): invalid datasetNamer <" + this.getName() + ">;" + " type is " + this.getType().toString() + ": matchPattern(" + this.getMatchPattern() + ") and substitutionPattern(" + this.getSubstitutePattern() + ") " + "must be null and attriuteContainer(" + this.getAttribContainer() + ") and attributeName(" + this.getAttribName() + ") must not be null.");
        }
        return this.isValid;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("DatasetNamer[name:<" + this.getName() + "> addLevel:<" + this.getAddLevel() + "> type:<" + this.getType() + "> matchPattern:<" + this.getMatchPattern() + "> substitutePatter:<" + this.getSubstitutePattern() + "> attribContainer:<" + this.getAttribContainer() + "> attribName:<" + this.getAttribName() + ">]");
        return tmp.toString();
    }

    public boolean nameDataset(InvDatasetImpl dataset) {
        if (this.type == DatasetNamerType.REGULAR_EXPRESSION) {
            return this.nameDatasetRegExp(dataset);
        }
        if (this.type == DatasetNamerType.DODS_ATTRIBUTE) {
            return this.nameDatasetDodsAttrib(dataset);
        }
        String tmpMsg = "This DatasetNamer <" + this.getName() + "> has unsupported type <" + this.type.toString() + ">.";
        logger.error("nameDataset(): " + tmpMsg);
        throw new IllegalStateException(tmpMsg);
    }

    public boolean nameDatasetList(List datasetList) throws Exception {
        boolean returnValue = false;
        InvDatasetImpl curDataset = null;
        for (int i = 0; i < datasetList.size(); ++i) {
            curDataset = (InvDatasetImpl)datasetList.get(i);
            returnValue &= this.nameDataset(curDataset);
        }
        return returnValue;
    }

    private boolean nameDatasetRegExp(InvDatasetImpl dataset) {
        RE regExp = null;
        REMatch regExpMatch = null;
        try {
            regExp = new RE((Object)this.matchPattern);
        }
        catch (REException e) {
            logger.debug("nameDatasetRegExp(): regular expression failed: {}", (Object)e.getMessage());
            return false;
        }
        if (dataset.getUrlPath() != null) {
            logger.debug("nameDatasetRegExp(): try naming on urlPath <{}>", (Object)dataset.getUrlPath());
            regExpMatch = regExp.getMatch((Object)dataset.getUrlPath());
        } else {
            regExpMatch = regExp.getMatch((Object)dataset.getName());
        }
        if (regExpMatch != null) {
            String name = regExpMatch.substituteInto(this.substitutePattern);
            if (name != null) {
                logger.debug("nameDatasetRegExp(): Setting name to \"" + name + "\".");
                dataset.setName(name);
                return true;
            }
            logger.debug("nameDatasetRegExp(): No name for regEx substitution.");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("nameDatasetRegExp(): Neither URL <" + dataset.getUrlPath() + "> or name <" + dataset.getName() + "> matched pattern <" + this.matchPattern + "> .");
        }
        return false;
    }

    private boolean nameDatasetDodsAttrib(InvDatasetImpl dataset) {
        DConnect dodsConnection = null;
        DAS das = null;
        boolean acceptDeflate = true;
        String newDatasetName = null;
        InvAccess access = dataset.getAccess(ServiceType.DODS);
        if (access == null) {
            logger.warn("nameDatasetDodsAttrib(): dataset is not DODS accessible and so cannot be named using DODS attributes.");
            return false;
        }
        String url = access.getStandardUrlName();
        try {
            dodsConnection = new DConnect(url, acceptDeflate);
        }
        catch (FileNotFoundException e) {
            logger.error("nameDatasetDodsAttrib(): URL <" + url + "> not found: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            logger.error("nameDatasetDodsAttrib(): Failed DODS connect: " + e.getMessage());
            return false;
        }
        logger.debug("nameDatasetDodsAttrib(): Got DODS Connect <url={}>", (Object)url);
        try {
            das = dodsConnection.getDAS();
        }
        catch (DAP2Exception e) {
            logger.error("nameDatasetDodsAttrib(): Failed to get DAS: " + e.getMessage());
            return false;
        }
        catch (ParseException e) {
            logger.error("nameDatasetDodsAttrib(): Failed to get DAS: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            logger.error("nameDatasetDodsAttrib(): Failed to get DAS: " + e.getMessage());
            return false;
        }
        logger.debug("nameDatasetDodsAttrib(): Got DAS");
        AttributeTable dodsAttTable = null;
        try {
            dodsAttTable = das.getAttributeTable(this.attribContainer);
            if (dodsAttTable != null) {
                Attribute desiredAtt = dodsAttTable.getAttribute(this.attribName);
                if (desiredAtt.getType() == 10) {
                    Enumeration enumValues = desiredAtt.getValues();
                    if (enumValues.hasMoreElements()) {
                        newDatasetName = (String)enumValues.nextElement();
                        newDatasetName = newDatasetName.substring(1, newDatasetName.length() - 1);
                        if (enumValues.hasMoreElements()) {
                            logger.warn("nameDatasetDodsAttrib(): attribute has multiple values, only using first value <" + newDatasetName + ">");
                            dataset.setName(newDatasetName);
                            return true;
                        }
                        logger.debug("nameDatasetDodsAttrib(): setting dataset name to <{}>.", (Object)newDatasetName);
                        dataset.setName(newDatasetName);
                        return true;
                    }
                    logger.debug("nameDatasetDodsAttrib(): attribute has no value");
                    return false;
                }
                logger.debug("nameDatasetDodsAttrib(): attribute value is not a string.");
                return false;
            }
            logger.debug("nameDatasetDodsAttrib(): attribute container does not exist.");
            return false;
        }
        catch (NoSuchAttributeException e) {
            logger.debug("nameDatasetDodsAttrib(): attribute container does not exist.");
            return false;
        }
    }
}

