/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import thredds.catalog.DataType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.dt.point.DapperDataset;
import ucar.nc2.dt.point.MadisStationObsDataset;
import ucar.nc2.dt.point.NdbcDataset;
import ucar.nc2.dt.point.OldUnidataPointObsDataset;
import ucar.nc2.dt.point.OldUnidataStationObsDataset;
import ucar.nc2.dt.point.SequenceObsDataset;
import ucar.nc2.dt.point.UnidataPointObsDataset;
import ucar.nc2.dt.point.UnidataStationObsDataset;
import ucar.nc2.dt.point.UnidataStationObsDataset2;
import ucar.nc2.dt.radial.Dorade2Dataset;
import ucar.nc2.dt.radial.LevelII2Dataset;
import ucar.nc2.dt.radial.Nids2Dataset;
import ucar.nc2.dt.trajectory.ARMTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.Float10TrajectoryObsDataset;
import ucar.nc2.dt.trajectory.RafTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.SimpleTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.ZebraClassTrajectoryObsDataset;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.util.CancelTask;

public class TypedDatasetFactory {
    private static List<Factory> transformList = new ArrayList<Factory>();
    private static boolean userMode = false;

    public static void registerFactory(DataType datatype, String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        TypedDatasetFactory.registerFactory(datatype, c);
    }

    public static void registerFactory(DataType datatype, Class c) {
        Object instance;
        if (!TypedDatasetFactoryIF.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement TypedDatasetFactoryIF");
        }
        try {
            instance = c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("CoordTransBuilderIF Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("CoordTransBuilderIF Class " + c.getName() + " is not accessible");
        }
        if (userMode) {
            transformList.add(0, new Factory(datatype, c, (TypedDatasetFactoryIF)instance));
        } else {
            transformList.add(new Factory(datatype, c, (TypedDatasetFactoryIF)instance));
        }
    }

    public static TypedDataset open(DataType datatype, String location, CancelTask task, StringBuffer errlog) throws IOException {
        if (location.startsWith("thredds:") && datatype != null) {
            ThreddsDataFactory.Result result = new ThreddsDataFactory().openDatatype(location, task);
            errlog.append(result.errLog);
            return result.fatalError ? null : result.tds;
        }
        NetcdfDataset ncd = NetcdfDataset.acquireDataset(location, task);
        return TypedDatasetFactory.open(datatype, ncd, task, errlog);
    }

    public static TypedDataset open(DataType datatype, NetcdfDataset ncd, CancelTask task, StringBuffer errlog) throws IOException {
        Class useClass = null;
        for (Factory fac : transformList) {
            if (datatype != null && datatype != fac.datatype || !fac.instance.isMine(ncd)) continue;
            useClass = fac.c;
            break;
        }
        if (null == useClass) {
            GridDataset gds;
            if (datatype == DataType.POINT) {
                return TypedDatasetFactory.open(DataType.STATION, ncd, task, errlog);
            }
            if (datatype == DataType.GRID) {
                return new GridDataset(ncd);
            }
            if (null == datatype && (gds = new GridDataset(ncd)).getGrids().size() > 0) {
                return gds;
            }
            errlog.append("**Failed to find Datatype Factory for= ").append(ncd.getLocation()).append(" datatype= ").append(datatype).append("\n");
            return null;
        }
        TypedDatasetFactoryIF builder = null;
        try {
            builder = (TypedDatasetFactoryIF)useClass.newInstance();
        }
        catch (InstantiationException e) {
            errlog.append(e.getMessage()).append("\n");
        }
        catch (IllegalAccessException e) {
            errlog.append(e.getMessage()).append("\n");
        }
        if (null == builder) {
            errlog.append("**Error on TypedDatasetFactory object from class= ").append(useClass.getName()).append("\n");
            return null;
        }
        return builder.open(ncd, task, errlog);
    }

    static {
        TypedDatasetFactory.registerFactory(DataType.POINT, UnidataPointObsDataset.class);
        TypedDatasetFactory.registerFactory(DataType.STATION, UnidataStationObsDataset.class);
        TypedDatasetFactory.registerFactory(DataType.POINT, DapperDataset.class);
        TypedDatasetFactory.registerFactory(DataType.STATION, SequenceObsDataset.class);
        TypedDatasetFactory.registerFactory(DataType.STATION, UnidataStationObsDataset2.class);
        TypedDatasetFactory.registerFactory(DataType.STATION, NdbcDataset.class);
        TypedDatasetFactory.registerFactory(DataType.STATION, MadisStationObsDataset.class);
        TypedDatasetFactory.registerFactory(DataType.STATION, OldUnidataStationObsDataset.class);
        TypedDatasetFactory.registerFactory(DataType.POINT, OldUnidataPointObsDataset.class);
        TypedDatasetFactory.registerFactory(DataType.RADIAL, Dorade2Dataset.class);
        TypedDatasetFactory.registerFactory(DataType.RADIAL, LevelII2Dataset.class);
        TypedDatasetFactory.registerFactory(DataType.RADIAL, Nids2Dataset.class);
        TypedDatasetFactory.registerFactory(DataType.TRAJECTORY, RafTrajectoryObsDataset.class);
        TypedDatasetFactory.registerFactory(DataType.TRAJECTORY, SimpleTrajectoryObsDataset.class);
        TypedDatasetFactory.registerFactory(DataType.TRAJECTORY, Float10TrajectoryObsDataset.class);
        TypedDatasetFactory.registerFactory(DataType.TRAJECTORY, ZebraClassTrajectoryObsDataset.class);
        TypedDatasetFactory.registerFactory(DataType.TRAJECTORY, ARMTrajectoryObsDataset.class);
        userMode = true;
    }

    private static class Factory {
        DataType datatype;
        Class c;
        TypedDatasetFactoryIF instance;

        Factory(DataType datatype, Class c, TypedDatasetFactoryIF instance) {
            this.datatype = datatype;
            this.c = c;
            this.instance = instance;
        }
    }
}

