/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import loci.common.IniList;
import loci.common.IniTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IniWriter.class);

    public void saveINI(IniList ini, String path) throws IOException {
        this.saveINI(ini, path, true);
    }

    public void saveINI(IniList ini, String path, boolean append) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(path, append));
        for (IniTable table : ini) {
            String header = (String)table.get("header");
            out.write("[" + header + "]\n");
            for (String key : table.keySet()) {
                out.write(key + " = " + (String)table.get(key) + "\n");
            }
            out.write("\n");
        }
        out.close();
    }
}

