/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.cache.CacheException;
import loci.formats.cache.ICacheSource;
import loci.formats.gui.BufferedImageReader;

public class BufferedImageSource
implements ICacheSource {
    protected BufferedImageReader reader;

    public BufferedImageSource(IFormatReader reader) throws CacheException {
        this.reader = reader instanceof BufferedImageReader ? (BufferedImageReader)reader : new BufferedImageReader(reader);
    }

    public int getObjectCount() {
        return this.reader.getImageCount();
    }

    public Object getObject(int index) throws CacheException {
        BufferedImage bi = null;
        try {
            bi = this.reader.openImage(index);
        }
        catch (FormatException exc) {
            throw new CacheException(exc);
        }
        catch (IOException exc) {
            throw new CacheException(exc);
        }
        return bi;
    }
}

