/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.ImagePlus;
import ij.measure.Calibration;
import java.util.Arrays;
import loci.formats.FormatTools;
import loci.formats.meta.IMetadata;
import loci.plugins.in.ImportProcess;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public class Calibrator {
    private final ImportProcess process;

    public Calibrator(ImportProcess process) {
        this.process = process;
    }

    public void applyCalibration(ImagePlus imp) {
        String type;
        int pixelType;
        boolean signed;
        boolean hasCalibration;
        boolean tcalPresent;
        Double td;
        PositiveFloat zd;
        PositiveFloat yd;
        IMetadata meta = this.process.getOMEMetadata();
        int series = (Integer)imp.getProperty("Series");
        double xcal = Double.NaN;
        double ycal = Double.NaN;
        double zcal = Double.NaN;
        double tcal = Double.NaN;
        PositiveFloat xd = meta.getPixelsPhysicalSizeX(series);
        if (xd != null) {
            xcal = (Double)xd.getValue();
        }
        if ((yd = meta.getPixelsPhysicalSizeY(series)) != null) {
            ycal = (Double)yd.getValue();
        }
        if ((zd = meta.getPixelsPhysicalSizeZ(series)) != null) {
            zcal = (Double)zd.getValue();
        }
        if ((td = meta.getPixelsTimeIncrement(series)) != null) {
            tcal = td.floatValue();
        }
        boolean xcalPresent = !Double.isNaN(xcal);
        boolean ycalPresent = !Double.isNaN(ycal);
        boolean zcalPresent = !Double.isNaN(zcal);
        boolean bl = tcalPresent = !Double.isNaN(tcal) && tcal != 0.0;
        if (xcalPresent && !ycalPresent) {
            ycal = xcal;
        } else if (ycalPresent && !xcalPresent) {
            xcal = ycal;
        }
        if (!tcalPresent) {
            tcal = this.computeVariableTimeInterval(meta, series);
        }
        xcalPresent = !Double.isNaN(xcal);
        ycalPresent = !Double.isNaN(ycal);
        zcalPresent = !Double.isNaN(zcal);
        tcalPresent = !Double.isNaN(tcal);
        boolean hasSpatial = xcalPresent || ycalPresent || zcalPresent;
        boolean bl2 = hasCalibration = hasSpatial || ycalPresent;
        if (hasCalibration) {
            Calibration cal = new Calibration();
            if (hasSpatial) {
                cal.setUnit("micron");
            }
            if (xcalPresent) {
                double d = cal.pixelWidth = xcal == 0.0 ? 1.0 : xcal;
            }
            if (ycalPresent) {
                double d = cal.pixelHeight = ycal == 0.0 ? 1.0 : ycal;
            }
            if (zcalPresent) {
                double d = cal.pixelDepth = zcal == 0.0 ? 1.0 : zcal;
            }
            if (tcalPresent) {
                cal.frameInterval = tcal == 0.0 ? 1.0 : tcal;
            }
            imp.setCalibration(cal);
        }
        boolean bl3 = signed = (pixelType = FormatTools.pixelTypeFromString(type = meta.getPixelsType(series).toString())) == 0 || pixelType == 2;
        if (signed) {
            int bitsPerPixel = FormatTools.getBytesPerPixel(pixelType) * 8;
            double min = -1.0 * Math.pow(2.0, bitsPerPixel - 1);
            imp.getLocalCalibration().setFunction(0, new double[]{min, 1.0}, "gray value");
        }
    }

    private double computeVariableTimeInterval(IMetadata meta, int series) {
        PositiveInteger sizeT = meta.getPixelsSizeT(series);
        int tSize = sizeT == null ? 1 : (Integer)sizeT.getValue();
        int planeCount = meta.getPlaneCount(series);
        double[] deltas = new double[tSize];
        Arrays.fill(deltas, Double.NaN);
        for (int p = 0; p < planeCount; ++p) {
            Double deltaT;
            int t;
            NonNegativeInteger theZ = meta.getPlaneTheZ(series, p);
            NonNegativeInteger theC = meta.getPlaneTheC(series, p);
            NonNegativeInteger theT = meta.getPlaneTheT(series, p);
            if (theZ == null || theC == null || theT == null || (Integer)theZ.getValue() != 0 || (Integer)theC.getValue() != 0 || (t = ((Integer)theT.getValue()).intValue()) >= tSize || (deltaT = meta.getPlaneDeltaT(series, p)) == null) continue;
            deltas[t] = deltaT;
        }
        double tiTotal = 0.0;
        int tiCount = 0;
        for (int t = 1; t < tSize; ++t) {
            double delta1 = deltas[t - 1];
            double delta2 = deltas[t];
            if (Double.isNaN(delta1) || Double.isNaN(delta2)) continue;
            tiTotal += delta2 - delta1;
            ++tiCount;
        }
        if (tiCount == 0) {
            return Double.NaN;
        }
        return (float)(tiTotal / (double)tiCount) / 1000.0f;
    }
}

