/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;

public class TransverseMercator
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "transverse_mercator";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double scale = this.readAttributeDouble(ctv, "scale_factor_at_central_meridian");
        double lon0 = this.readAttributeDouble(ctv, "longitude_of_central_meridian");
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin");
        double east = this.readAttributeDouble(ctv, "false_easting");
        double north = this.readAttributeDouble(ctv, "false_northing");
        if (!Double.isNaN(east) || !Double.isNaN(north)) {
            double scalef = this.getFalseEastingScaleFactor(ds, ctv);
            east *= scalef;
            north *= scalef;
        }
        ucar.unidata.geoloc.projection.TransverseMercator proj = new ucar.unidata.geoloc.projection.TransverseMercator(lat0, lon0, scale, east, north);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

