/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml4;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileFactory;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.ncml4.Aggregation;
import ucar.nc2.ncml4.MyCrawlableDataset;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregationOuterDimension
extends Aggregation {
    protected List<VariableDS> aggVars = new ArrayList<VariableDS>();
    private int totalCoords = 0;
    protected List<String> aggVarNames = new ArrayList<String>();
    protected List<CacheVar> cacheList = new ArrayList<CacheVar>();
    protected boolean timeUnitsChange = false;
    protected boolean debugCache = true;

    protected AggregationOuterDimension(NetcdfDataset ncd, String dimName, AggregationIF.Type type, String recheckS) {
        super(ncd, dimName, type, recheckS);
    }

    void setTimeUnitsChange(boolean timeUnitsChange) {
        this.timeUnitsChange = timeUnitsChange;
        if (timeUnitsChange) {
            this.isDate = true;
        }
    }

    public void addVariable(String varName) {
        this.aggVarNames.add(varName);
    }

    void addVariableFromGlobalAttribute(String varName, String orgName) {
        this.cacheList.add(new PromoteVar(varName, orgName));
    }

    void addCacheVariable(String varName) {
        this.cacheList.add(new CacheVar(varName));
    }

    @Override
    public String getDimensionName() {
        return this.dimName;
    }

    List<String> getAggVariableNames() {
        return this.aggVarNames;
    }

    protected void buildCoords(CancelTask cancelTask) throws IOException {
        DatasetOuterDimension dod;
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        if (this.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) {
            for (Aggregation.Dataset nested : nestedDatasets) {
                dod = (DatasetOuterDimension)nested;
                dod.ncoord = 1;
            }
        }
        this.totalCoords = 0;
        for (Aggregation.Dataset nested : nestedDatasets) {
            dod = (DatasetOuterDimension)nested;
            this.totalCoords += dod.setStartEnd(this.totalCoords, cancelTask);
        }
    }

    protected int getTotalCoords() {
        return this.totalCoords;
    }

    protected void promoteGlobalAttributes(DatasetOuterDimension typicalDataset) throws IOException {
        for (CacheVar cv : this.cacheList) {
            if (!(cv instanceof PromoteVar)) continue;
            PromoteVar pv = (PromoteVar)cv;
            Array data = pv.read(typicalDataset);
            pv.dtype = DataType.getType(data.getElementType());
            VariableDS promotedVar = new VariableDS(this.ncDataset, null, null, pv.varName, pv.dtype, this.dimName, null, null);
            this.ncDataset.addVariable(null, promotedVar);
            promotedVar.setProxyReader(this);
            promotedVar.setSPobject(pv);
        }
    }

    @Override
    protected void rebuildDataset() throws IOException {
        this.buildCoords(null);
        Dimension aggDim = this.ncDataset.findDimension(this.dimName);
        aggDim.setLength(this.getTotalCoords());
        VariableDS joinAggCoord = (VariableDS)this.ncDataset.getRootGroup().findVariable(this.dimName);
        joinAggCoord.setDimensions(this.dimName);
        joinAggCoord.invalidateCache();
        for (VariableDS aggVar : this.aggVars) {
            aggVar.setDimensions(this.dimName);
            aggVar.invalidateCache();
        }
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        Aggregation.DatasetProxyReader proxy = new Aggregation.DatasetProxyReader(typicalDataset);
        for (Variable var : this.ncDataset.getRootGroup().getVariables()) {
            VariableDS varDS = (VariableDS)var;
            if (this.aggVars.contains(varDS) || this.dimName.equals(var.getName())) continue;
            VariableEnhanced ve = (VariableEnhanced)((Object)var);
            ve.setProxyReader(proxy);
        }
        for (CacheVar cv : this.cacheList) {
            cv.reset();
        }
    }

    @Override
    public Array read(Variable mainv, CancelTask cancelTask) throws IOException {
        Object spObj = mainv.getSPobject();
        if (spObj != null && spObj instanceof CacheVar) {
            CacheVar pv = (CacheVar)spObj;
            try {
                return pv.read(mainv.getShapeAsSection(), cancelTask);
            }
            catch (InvalidRangeException e) {
                logger.error("readAgg " + this.getLocation(), e);
                throw new IllegalArgumentException("readAgg " + this.getLocation(), e);
            }
        }
        DataType dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Array allData = Array.factory(dtype, mainv.getShape());
        int destPos = 0;
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        for (Aggregation.Dataset vnested : nestedDatasets) {
            Array varData = vnested.read(mainv, cancelTask);
            if (cancelTask != null && cancelTask.isCancel()) {
                return null;
            }
            Array.arraycopy(varData, 0, allData, destPos, (int)varData.getSize());
            destPos = (int)((long)destPos + varData.getSize());
        }
        return allData;
    }

    @Override
    public Array read(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        long size = section.computeSize();
        if (size == mainv.getSize()) {
            return this.read(mainv, cancelTask);
        }
        Object spObj = mainv.getSPobject();
        if (spObj != null && spObj instanceof CacheVar) {
            CacheVar pv = (CacheVar)spObj;
            return pv.read(mainv.getShapeAsSection(), cancelTask);
        }
        DataType dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Array sectionData = Array.factory(dtype, section.getShape());
        int destPos = 0;
        List<Range> ranges = section.getRanges();
        Range joinRange = section.getRange(0);
        ArrayList<Range> nestedSection = new ArrayList<Range>(ranges);
        List<Range> innerSection = ranges.subList(1, ranges.size());
        if (this.debug) {
            System.out.println("   agg wants range=" + mainv.getName() + "(" + joinRange + ")");
        }
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        for (Aggregation.Dataset nested : nestedDatasets) {
            Array varData;
            DatasetOuterDimension dod = (DatasetOuterDimension)nested;
            Range nestedJoinRange = dod.getNestedJoinRange(joinRange);
            if (nestedJoinRange == null) continue;
            if (this.type == AggregationIF.Type.JOIN_NEW || this.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) {
                varData = dod.read(mainv, cancelTask, innerSection);
            } else {
                nestedSection.set(0, nestedJoinRange);
                varData = dod.read(mainv, cancelTask, nestedSection);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return null;
            }
            Array.arraycopy(varData, 0, sectionData, destPos, (int)varData.getSize());
            destPos = (int)((long)destPos + varData.getSize());
        }
        return sectionData;
    }

    @Override
    protected Aggregation.Dataset makeDataset(String cacheName, String location, String ncoordS, String coordValueS, String sectionSpec, boolean enhance, NetcdfFileFactory reader) {
        return new DatasetOuterDimension(cacheName, location, ncoordS, coordValueS, enhance, reader);
    }

    class PromoteVar
    extends CacheVar {
        String orgName;

        PromoteVar(String varName, String orgName) {
            super(varName);
            this.orgName = orgName != null ? orgName : varName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Array read(DatasetOuterDimension dset) throws IOException {
            Array data = this.getData(dset);
            if (data != null) {
                return data;
            }
            NetcdfFile ncfile = null;
            try {
                ncfile = dset.acquireFile(null);
                Attribute att = ncfile.findGlobalAttribute(this.orgName);
                data = att.getValues();
                this.setData(dset, data);
                Array array = data;
                return array;
            }
            finally {
                dset.close(ncfile);
            }
        }
    }

    class CoordValueVar
    extends CacheVar {
        Variable v;
        Section innerSection;

        CoordValueVar(Variable v) {
            super(v.getName());
            this.dtype = v.getDataType();
            List<Range> ranges = v.getShapeAsSection().getRanges();
            this.innerSection = new Section(ranges.subList(1, ranges.size()));
        }

        protected Array read(DatasetOuterDimension dset) throws IOException {
            Array data = this.getData(dset);
            if (data != null) {
                return data;
            }
            data = Array.factory(this.dtype, this.innerSection.getShape());
            IndexIterator ii = data.getIndexIterator();
            if (dset.coordValue != null) {
                if (dset.ncoord == 1) {
                    if (this.dtype == DataType.STRING) {
                        ii.setObjectNext(dset.coordValue);
                    } else {
                        double val = Double.parseDouble(dset.coordValue);
                        ii.setDoubleNext(val);
                    }
                } else {
                    int count = 0;
                    StringTokenizer stoker = new StringTokenizer(dset.coordValue, " ,");
                    while (stoker.hasMoreTokens()) {
                        String toke = stoker.nextToken();
                        if (this.dtype == DataType.STRING) {
                            ii.setObjectNext(toke);
                        } else {
                            double val = Double.parseDouble(toke);
                            ii.setDoubleNext(val);
                        }
                        ++count;
                    }
                    if (count != dset.ncoord) {
                        Aggregation.logger.error("readAggCoord incorrect number of coordinates dataset=" + dset.getLocation());
                        throw new IllegalArgumentException("readAggCoord incorrect number of coordinates dataset=" + dset.getLocation());
                    }
                }
                this.setData(dset, data);
                return data;
            }
            return super.read(dset);
        }
    }

    class CacheVar {
        String varName;
        DataType dtype;
        Map<String, Array> dataMap = new HashMap<String, Array>();

        CacheVar(String varName) {
            this.varName = varName;
        }

        void reset() {
            HashMap<String, Array> newMap = new HashMap<String, Array>();
            for (Aggregation.Dataset ds : AggregationOuterDimension.this.datasets) {
                String location = ds.getLocation();
                Array data = this.dataMap.get(location);
                if (data == null) continue;
                newMap.put(location, data);
            }
            this.dataMap = newMap;
        }

        Array read(Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
            if (AggregationOuterDimension.this.debugCache) {
                System.out.println("caching " + this.varName + " section= " + section);
            }
            Array allData = Array.factory(this.dtype, section.getShape());
            List<Range> ranges = section.getRanges();
            Range joinRange = section.getRange(0);
            Section innerSection = null;
            if (section.getRank() > 1) {
                innerSection = new Section(ranges.subList(1, ranges.size()));
            }
            int resultPos = 0;
            List<Aggregation.Dataset> nestedDatasets = AggregationOuterDimension.this.getDatasets();
            for (Aggregation.Dataset vnested : nestedDatasets) {
                DatasetOuterDimension dod = (DatasetOuterDimension)vnested;
                Range nestedJoinRange = dod.getNestedJoinRange(joinRange);
                if (nestedJoinRange == null) continue;
                Array varData = this.read(dod);
                if (innerSection != null && varData.getSize() != innerSection.computeSize()) {
                    varData = varData.section(innerSection.getRanges());
                }
                int nelems = (int)varData.getSize();
                Array.arraycopy(varData, 0, allData, resultPos, nelems);
                resultPos += nelems;
                if (cancelTask == null || !cancelTask.isCancel()) continue;
                return null;
            }
            return allData;
        }

        protected void setData(Aggregation.Dataset dset, Array data) {
            this.dataMap.put(dset.getLocation(), data);
        }

        protected Array getData(Aggregation.Dataset dset) {
            return this.dataMap.get(dset.getLocation());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Array read(DatasetOuterDimension dset) throws IOException {
            Array data = this.getData(dset);
            if (data != null) {
                return data;
            }
            NetcdfFile ncfile = null;
            try {
                ncfile = dset.acquireFile(null);
                Variable v = ncfile.findVariable(this.varName);
                data = v.read();
                this.setData(dset, data);
                Array array = data;
                return array;
            }
            finally {
                dset.close(ncfile);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DatasetOuterDimension
    extends Aggregation.Dataset {
        protected int ncoord;
        protected String coordValue;
        protected Date coordValueDate;
        protected boolean isStringValued;
        private int aggStart;
        private int aggEnd;

        protected DatasetOuterDimension(String location) {
            super(location);
            this.isStringValued = false;
            this.aggStart = 0;
            this.aggEnd = 0;
        }

        protected DatasetOuterDimension(String cacheName, String location, String ncoordS, String coordValueS, boolean enhance, NetcdfFileFactory reader) {
            super(cacheName, location, enhance, reader);
            this.isStringValued = false;
            this.aggStart = 0;
            this.aggEnd = 0;
            this.coordValue = coordValueS;
            if (AggregationOuterDimension.this.type == AggregationIF.Type.JOIN_NEW || AggregationOuterDimension.this.type == AggregationIF.Type.JOIN_EXISTING_ONE) {
                this.ncoord = 1;
            } else if (ncoordS != null) {
                try {
                    this.ncoord = Integer.parseInt(ncoordS);
                }
                catch (NumberFormatException e) {
                    Aggregation.logger.error("bad ncoord attribute on dataset=" + location);
                }
            }
            if (AggregationOuterDimension.this.type == AggregationIF.Type.JOIN_NEW || AggregationOuterDimension.this.type == AggregationIF.Type.JOIN_EXISTING_ONE || AggregationOuterDimension.this.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) {
                if (coordValueS == null) {
                    int pos = this.location.lastIndexOf("/");
                    this.coordValue = pos < 0 ? this.location : this.location.substring(pos + 1);
                    this.isStringValued = true;
                } else {
                    try {
                        Double.parseDouble(coordValueS);
                    }
                    catch (NumberFormatException e) {
                        this.isStringValued = true;
                    }
                }
            }
            if (AggregationOuterDimension.this.type == AggregationIF.Type.JOIN_EXISTING && coordValueS != null) {
                StringTokenizer stoker = new StringTokenizer(coordValueS, " ,");
                this.ncoord = stoker.countTokens();
            }
        }

        @Override
        protected void setInfo(MyCrawlableDataset myf) {
            super.setInfo(myf);
            this.coordValueDate = myf.dateCoord;
        }

        public String getCoordValueString() {
            return this.coordValue;
        }

        public Date getCoordValueDate() {
            return this.coordValueDate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNcoords(CancelTask cancelTask) throws IOException {
            if (this.ncoord <= 0) {
                NetcdfFile ncd = null;
                try {
                    ncd = this.acquireFile(cancelTask);
                    if (cancelTask != null && cancelTask.isCancel()) {
                        int n = 0;
                        return n;
                    }
                    Dimension d = ncd.getRootGroup().findDimension(AggregationOuterDimension.this.dimName);
                    if (d != null) {
                        this.ncoord = d.getLength();
                    }
                }
                finally {
                    this.close(ncd);
                }
            }
            return this.ncoord;
        }

        protected int setStartEnd(int aggStart, CancelTask cancelTask) throws IOException {
            this.aggStart = aggStart;
            this.aggEnd = aggStart + this.getNcoords(cancelTask);
            return this.ncoord;
        }

        protected Range getNestedJoinRange(Range totalRange) throws InvalidRangeException {
            int wantStop;
            int wantStart = totalRange.first();
            if (!this.isNeeded(wantStart, wantStop = totalRange.last() + 1)) {
                return null;
            }
            int firstInInterval = totalRange.getFirstInInterval(this.aggStart);
            if (firstInInterval < 0 || firstInInterval >= this.aggEnd) {
                return null;
            }
            int start = Math.max(this.aggStart, wantStart) - this.aggStart;
            int stop = Math.min(this.aggEnd, wantStop) - this.aggStart;
            return new Range(start, stop - 1, totalRange.stride());
        }

        protected boolean isNeeded(Range totalRange) {
            int wantStart = totalRange.first();
            int wantStop = totalRange.last() + 1;
            return this.isNeeded(wantStart, wantStop);
        }

        private boolean isNeeded(int wantStart, int wantStop) {
            if (wantStart >= wantStop) {
                return false;
            }
            return wantStart < this.aggEnd && wantStop > this.aggStart;
        }

        @Override
        protected void cacheVariables(NetcdfFile ncfile) throws IOException {
            for (CacheVar pv : AggregationOuterDimension.this.cacheList) {
                pv.read(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Array read(Variable mainv, CancelTask cancelTask, List<Range> section) throws IOException, InvalidRangeException {
            NetcdfFile ncd = null;
            try {
                ncd = this.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                if (AggregationOuterDimension.this.debugRead) {
                    System.out.print("agg read " + ncd.getLocation() + " nested= " + this.getLocation());
                    for (Range range : section) {
                        System.out.print(" " + range + ":");
                    }
                    System.out.println("");
                }
                Variable v = ncd.findVariable(mainv.getName());
                Range fullRange = v.getRanges().get(0);
                Range want = section.get(0);
                if (fullRange.last() < want.last()) {
                    Range limitRange = new Range(want.first(), fullRange.last(), want.stride());
                    section = new ArrayList<Range>(section);
                    section.set(0, limitRange);
                }
                Array array = v.read(section);
                return array;
            }
            finally {
                this.close(ncd);
            }
        }
    }
}

