/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import loci.plugins.BF;
import loci.plugins.util.WindowTools;

public class Updater
implements PlugIn {
    public static final String TRUNK_BUILD = "http://dev.loci.wisc.edu:8080/job/Bio-Formats/lastSuccessfulBuild/artifact/artifacts/loci_tools.jar";
    public static final String TODAYS_BUILD = "http://loci.wisc.edu/software/daily/loci_tools.jar";
    public static final String YESTERDAYS_BUILD = "http://loci.wisc.edu/software/daily.old/loci_tools.jar";
    public static final String STABLE_BUILD = "http://loci.wisc.edu/software/loci_tools.jar";
    public static final String STABLE_VERSION = "4.2-DEV";
    public static final String REGISTRY = "http://upgrade.openmicroscopy.org.uk";
    public static final String[] REGISTRY_PROPERTIES = new String[]{"version", "os.name", "os.version", "os.arch", "java.runtime.version", "java.vm.vendor"};
    public static final int CHUNK_SIZE = 8192;
    public boolean canceled;
    private String urlPath;

    public void run(String arg) {
        GenericDialog upgradeDialog = new GenericDialog("Update LOCI Plugins");
        String[] options = new String[]{"Trunk build", "Daily build (today)", "Daily build (yesterday)", "Stable build (4.2-DEV)"};
        upgradeDialog.addChoice("Release", options, options[0]);
        upgradeDialog.showDialog();
        if (upgradeDialog.wasCanceled()) {
            this.canceled = true;
            return;
        }
        String release = upgradeDialog.getNextChoice();
        this.urlPath = release.equals(options[0]) ? TRUNK_BUILD : (release.equals(options[1]) ? TODAYS_BUILD : (release.equals(options[2]) ? YESTERDAYS_BUILD : STABLE_BUILD));
        Updater.install(this.urlPath);
    }

    public static boolean newVersionAvailable() {
        StringBuffer query = new StringBuffer(REGISTRY);
        for (int i = 0; i < REGISTRY_PROPERTIES.length; ++i) {
            if (i == 0) {
                query.append("?");
            } else {
                query.append(";");
            }
            query.append(REGISTRY_PROPERTIES[i]);
            query.append("=");
            if (i == 0) {
                query.append("4.3.1-DEV");
                continue;
            }
            try {
                query.append(URLEncoder.encode(System.getProperty(REGISTRY_PROPERTIES[i]), "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        try {
            int data;
            URLConnection conn = new URL(query.toString()).openConnection();
            conn.setConnectTimeout(5000);
            conn.setUseCaches(false);
            conn.addRequestProperty("User-Agent", "OMERO.imagej");
            conn.connect();
            InputStream in = conn.getInputStream();
            StringBuffer latestVersion = new StringBuffer();
            while ((data = in.read()) != -1) {
                latestVersion.append((char)data);
            }
            in.close();
            String[] version = latestVersion.toString().split("\\.");
            String[] thisVersion = "4.3.1-DEV".split("\\.");
            for (int i = 0; i < thisVersion.length; ++i) {
                int subVersion = Integer.parseInt(thisVersion[i]);
                try {
                    int registrySubVersion = Integer.parseInt(version[i]);
                    if (registrySubVersion > subVersion) {
                        return true;
                    }
                    if (registrySubVersion >= subVersion) continue;
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static void install(String urlPath) {
        String pluginsDirectory = IJ.getDirectory((String)"plugins");
        String jarPath = pluginsDirectory + File.separator + "loci_tools.jar";
        String downloadPath = jarPath + ".tmp";
        File plugin = new File(downloadPath);
        if (plugin.exists() && !plugin.delete()) {
            BF.status(false, "");
            BF.progress(false, 1, 1);
            WindowTools.reportException(new IOException("Could not delete " + downloadPath), false, "An error occurred while downloading the LOCI plugins");
            return;
        }
        BF.status(false, "Connecting to download server...");
        try {
            int r;
            URL url = new URL(urlPath);
            URLConnection urlConn = url.openConnection();
            int total = urlConn.getContentLength();
            byte[] buf = new byte[total];
            DataInputStream in = new DataInputStream(new BufferedInputStream(urlConn.getInputStream()));
            for (int off = 0; off < total; off += r) {
                BF.status(false, "Downloading loci_tools.jar...");
                BF.progress(false, off, total);
                int len = 8192;
                if (off + len > total) {
                    len = total - off;
                }
                if ((r = in.read(buf, off, len)) > 0) continue;
                BF.status(false, "");
                IJ.showMessage((String)"Error downloading the LOCI plugins.");
                return;
            }
            in.close();
            BF.progress(false, 1, 1);
            BF.status(false, "Saving loci_tools.jar...");
            FileOutputStream out = new FileOutputStream(plugin);
            out.write(buf);
            out.close();
            boolean success = plugin.renameTo(new File(jarPath));
            if (!success) {
                BF.status(false, "");
                IJ.showMessage((String)("The LOCI plugins have been downloaded to:\n" + downloadPath + "\n" + "The JAR file could not be renamed to loci_tools.jar.\n" + "Please rename " + downloadPath + " to\n" + jarPath + "\n" + "and restart ImageJ to complete the upgrade process."));
                return;
            }
        }
        catch (IOException e) {
            BF.status(false, "");
            BF.progress(false, 1, 1);
            WindowTools.reportException(e, false, "An error occurred while downloading the LOCI plugins");
            return;
        }
        BF.status(false, "");
        IJ.showMessage((String)"The LOCI plugins have been downloaded.\nPlease restart ImageJ to complete the upgrade process.");
    }
}

