/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.filesystem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import loci.common.RandomAccessInputStream;
import loci.poi.poifs.dev.POIFSViewable;
import loci.poi.poifs.filesystem.BATManaged;
import loci.poi.poifs.filesystem.DocumentOutputStream;
import loci.poi.poifs.filesystem.POIFSDocumentPath;
import loci.poi.poifs.filesystem.POIFSWriterEvent;
import loci.poi.poifs.filesystem.POIFSWriterListener;
import loci.poi.poifs.property.DocumentProperty;
import loci.poi.poifs.property.Property;
import loci.poi.poifs.storage.BlockWritable;
import loci.poi.poifs.storage.DocumentBlock;
import loci.poi.poifs.storage.ListManagedBlock;
import loci.poi.poifs.storage.RawDataBlock;
import loci.poi.poifs.storage.SmallDocumentBlock;
import loci.poi.util.HexDump;

public class POIFSDocument
implements BATManaged,
BlockWritable,
POIFSViewable {
    private DocumentProperty _property;
    private int _size;
    private SmallBlockStore _small_store;
    private BigBlockStore _big_store;
    private int bigBlockSize;

    public POIFSDocument(String name, RawDataBlock[] blocks, int length) throws IOException {
        this.bigBlockSize = blocks[0].getBlockSize();
        this._size = length;
        this._big_store = new BigBlockStore(blocks);
        this._property = new DocumentProperty(name, this._size);
        this._small_store = new SmallBlockStore(new BlockWritable[0]);
        this._property.setDocument(this);
    }

    public POIFSDocument(String name, SmallDocumentBlock[] blocks, int length) {
        this.bigBlockSize = blocks[0].getBigBlockSize();
        this._size = length;
        try {
            this._big_store = new BigBlockStore(new RawDataBlock[0]);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        this._property = new DocumentProperty(name, this._size);
        this._small_store = new SmallBlockStore(blocks);
        this._property.setDocument(this);
    }

    public POIFSDocument(String name, ListManagedBlock[] blocks, int length, int size) throws IOException {
        this.bigBlockSize = size;
        this._size = length;
        this._property = new DocumentProperty(name, this._size);
        this._property.setDocument(this);
        if (Property.isSmall(this._size)) {
            this._big_store = new BigBlockStore(new RawDataBlock[0]);
            this._small_store = new SmallBlockStore(blocks);
        } else {
            this._big_store = new BigBlockStore(blocks);
            this._small_store = new SmallBlockStore(new BlockWritable[0]);
        }
    }

    public POIFSDocument(String name, RandomAccessInputStream stream, int size) throws IOException {
        DocumentBlock block;
        ArrayList<DocumentBlock> blocks = new ArrayList<DocumentBlock>();
        this.bigBlockSize = size;
        this._size = 0;
        do {
            int blockSize;
            if ((blockSize = (block = new DocumentBlock(stream, size)).size()) <= 0) continue;
            blocks.add(block);
            this._size += blockSize;
        } while (!block.partiallyRead());
        Object[] bigBlocks = blocks.toArray(new DocumentBlock[0]);
        this._big_store = new BigBlockStore(bigBlocks);
        this._property = new DocumentProperty(name, this._size);
        this._property.setDocument(this);
        if (this._property.shouldUseSmallBlocks()) {
            this._small_store = new SmallBlockStore(SmallDocumentBlock.convert((BlockWritable[])bigBlocks, size));
            this._big_store = new BigBlockStore(new DocumentBlock[0]);
        } else {
            this._small_store = new SmallBlockStore(new BlockWritable[0]);
        }
    }

    public POIFSDocument(String name, int size, POIFSDocumentPath path, POIFSWriterListener writer, int blockSize) throws IOException {
        this.bigBlockSize = blockSize;
        this._size = size;
        this._property = new DocumentProperty(name, this._size);
        this._property.setDocument(this);
        if (this._property.shouldUseSmallBlocks()) {
            this._small_store = new SmallBlockStore(path, name, size, writer);
            this._big_store = new BigBlockStore(new Object[0]);
        } else {
            this._small_store = new SmallBlockStore(new BlockWritable[0]);
            this._big_store = new BigBlockStore(path, name, size, writer);
        }
    }

    public BlockWritable[] getSmallBlocks() {
        return this._small_store.getBlocks();
    }

    public DocumentBlock[] getBigBlocks() {
        return this._big_store.getBlocks();
    }

    public int getSize() {
        return this._size;
    }

    public int getBigBlockSize() {
        return this.bigBlockSize;
    }

    void read(byte[] buffer, int offset, RandomAccessInputStream stream) {
        if (this._property.shouldUseSmallBlocks()) {
            if (this.bigBlockSize == 0) {
                this.bigBlockSize = this._small_store.getBigBlockSize();
            }
            SmallDocumentBlock.read(this._small_store.getBlocks(), buffer, offset);
        } else {
            if (this.bigBlockSize == 0) {
                this.bigBlockSize = this._big_store.getBigBlockSize();
            }
            DocumentBlock.read(this._big_store.getBlocks(), buffer, offset, this.bigBlockSize, stream);
        }
    }

    DocumentProperty getDocumentProperty() {
        return this._property;
    }

    public void writeBlocks(OutputStream stream) throws IOException {
        this._big_store.writeBlocks(stream);
    }

    public int countBlocks() {
        return this._big_store.countBlocks();
    }

    public void setStartBlock(int index) {
        this._property.setStartBlock(index);
    }

    public Object[] getViewableArray() {
        String result;
        Object[] results = new Object[1];
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            BlockWritable[] blocks = null;
            if (this._big_store.isValid()) {
                blocks = this._big_store.getBlocks();
            } else if (this._small_store.isValid()) {
                blocks = this._small_store.getBlocks();
            }
            if (blocks != null) {
                for (int k = 0; k < blocks.length; ++k) {
                    blocks[k].writeBlocks(output);
                }
                byte[] data = output.toByteArray();
                if (data.length > this._property.getSize()) {
                    byte[] tmp = new byte[this._property.getSize()];
                    System.arraycopy(data, 0, tmp, 0, tmp.length);
                    data = tmp;
                }
                output = new ByteArrayOutputStream();
                HexDump.dump(data, 0L, output, 0);
                result = output.toString();
            } else {
                result = "<NO DATA>";
            }
        }
        catch (IOException e) {
            result = e.getMessage();
        }
        results[0] = result;
        return results;
    }

    public Iterator getViewableIterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean preferArray() {
        return true;
    }

    public String getShortDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Document: \"").append(this._property.getName()).append("\"");
        buffer.append(" size = ").append(this.getSize());
        return buffer.toString();
    }

    private class BigBlockStore {
        private DocumentBlock[] bigBlocks;
        private POIFSDocumentPath path;
        private String name;
        private int size;
        private POIFSWriterListener writer;

        BigBlockStore(Object[] blocks) throws IOException {
            this.bigBlocks = new DocumentBlock[blocks.length];
            for (int j = 0; j < blocks.length; ++j) {
                this.bigBlocks[j] = blocks[j] instanceof DocumentBlock ? (DocumentBlock)blocks[j] : new DocumentBlock((RawDataBlock)blocks[j], ((RawDataBlock)blocks[j]).getBlockSize());
            }
            this.path = null;
            this.name = null;
            this.size = -1;
            this.writer = null;
        }

        BigBlockStore(POIFSDocumentPath path, String name, int size, POIFSWriterListener writer) {
            this.bigBlocks = new DocumentBlock[0];
            this.path = path;
            this.name = name;
            this.size = size;
            this.writer = writer;
        }

        int getBigBlockSize() {
            return this.bigBlocks[0].getBigBlockSize();
        }

        boolean isValid() {
            return this.bigBlocks.length > 0 || this.writer != null;
        }

        DocumentBlock[] getBlocks() {
            if (this.isValid() && this.writer != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(this.size);
                DocumentOutputStream dstream = new DocumentOutputStream(stream, this.size);
                this.writer.processPOIFSWriterEvent(new POIFSWriterEvent(dstream, this.path, this.name, this.size));
                try {
                    RandomAccessInputStream s = new RandomAccessInputStream(stream.toByteArray());
                    this.bigBlocks = DocumentBlock.convert(0L, s, (int)s.length(), this.size, POIFSDocument.this.bigBlockSize);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.bigBlocks;
        }

        void writeBlocks(OutputStream stream) throws IOException {
            if (this.isValid()) {
                if (this.writer != null) {
                    DocumentOutputStream dstream = new DocumentOutputStream(stream, this.size);
                    this.writer.processPOIFSWriterEvent(new POIFSWriterEvent(dstream, this.path, this.name, this.size));
                    dstream.writeFiller(this.countBlocks() * POIFSDocument.this.bigBlockSize, DocumentBlock.getFillByte());
                } else {
                    for (int k = 0; k < this.bigBlocks.length; ++k) {
                        this.bigBlocks[k].writeBlocks(stream);
                    }
                }
            }
        }

        int countBlocks() {
            int rval = 0;
            if (this.isValid()) {
                rval = this.writer != null ? (this.size + POIFSDocument.this.bigBlockSize - 1) / POIFSDocument.this.bigBlockSize : this.bigBlocks.length;
            }
            return rval;
        }
    }

    private class SmallBlockStore {
        private SmallDocumentBlock[] smallBlocks;
        private POIFSDocumentPath path;
        private String name;
        private int size;
        private POIFSWriterListener writer;

        SmallBlockStore(Object[] blocks) {
            this.smallBlocks = new SmallDocumentBlock[blocks.length];
            for (int j = 0; j < blocks.length; ++j) {
                this.smallBlocks[j] = (SmallDocumentBlock)blocks[j];
            }
            this.path = null;
            this.name = null;
            this.size = -1;
            this.writer = null;
        }

        SmallBlockStore(POIFSDocumentPath path, String name, int size, POIFSWriterListener writer) {
            this.smallBlocks = new SmallDocumentBlock[0];
            this.path = path;
            this.name = name;
            this.size = size;
            this.writer = writer;
        }

        int getBigBlockSize() {
            return this.smallBlocks[0].getBigBlockSize();
        }

        boolean isValid() {
            return this.smallBlocks.length > 0 || this.writer != null;
        }

        BlockWritable[] getBlocks() {
            if (this.isValid() && this.writer != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(this.size);
                DocumentOutputStream dstream = new DocumentOutputStream(stream, this.size);
                this.writer.processPOIFSWriterEvent(new POIFSWriterEvent(dstream, this.path, this.name, this.size));
                this.smallBlocks = SmallDocumentBlock.convert(stream.toByteArray(), this.size);
            }
            return this.smallBlocks;
        }
    }
}

