/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.dqc.Selection;
import thredds.dqc.Selector;

public class SelectFromRange
extends Selector {
    private static Logger log = LoggerFactory.getLogger(SelectFromRange.class);
    protected double allowedRangeMin = 0.0;
    protected double allowedRangeMax = 0.0;
    protected String units = null;
    protected String template = null;
    protected boolean modulo = false;
    protected double moduloValue = 0.0;

    public double getAllowedRangeMin() {
        return this.allowedRangeMin;
    }

    public double getAllowedRangeMax() {
        return this.allowedRangeMax;
    }

    public void setAllowedRange(double min, double max) {
        if (min > max) {
            String tmp = "setAllowedRange(): the low end of the allowed range <" + min + "> is greater than the high end of the allowed range <" + max + ">.";
            log.debug(tmp);
            throw new IllegalArgumentException(tmp);
        }
        this.allowedRangeMin = min;
        this.allowedRangeMax = max;
        this.moduloValue = this.allowedRangeMax - this.allowedRangeMin;
        log.debug("setAllowedRange(): set min <" + min + ">, max <" + max + ">, and modulo value <" + this.moduloValue + ">.");
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean isModulo() {
        return this.modulo;
    }

    public void setModulo(boolean modulo) {
        this.modulo = modulo;
    }

    public Selection validateSelection(Selection selection) {
        return null;
    }
}

