/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.ArrayBoolean;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayLong;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.Index0D;
import ucar.ma2.IndexConstant;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Array {
    public static final Index scalarIndex = new Index0D(new int[0]);
    protected final Index indexCalc;
    protected final int rank;
    private IndexIterator ii;

    public static Array factory(DataType dataType, int[] shape) {
        Index index = Index.factory(shape);
        return Array.factory(dataType.getPrimitiveClassType(), index);
    }

    public static Array factory(Class classType, int[] shape) {
        Index index = Index.factory(shape);
        return Array.factory(classType, index);
    }

    public static Array factoryConstant(Class classType, int[] shape, Object storage) {
        IndexConstant index = new IndexConstant(shape);
        if (classType == Double.TYPE || classType == Double.class) {
            return new ArrayDouble(index, (double[])storage);
        }
        if (classType == Float.TYPE || classType == Float.class) {
            return new ArrayFloat(index, (float[])storage);
        }
        if (classType == Long.TYPE || classType == Long.class) {
            return new ArrayLong(index, (long[])storage);
        }
        if (classType == Integer.TYPE || classType == Integer.class) {
            return new ArrayInt(index, (int[])storage);
        }
        if (classType == Short.TYPE || classType == Short.class) {
            return new ArrayShort(index, (short[])storage);
        }
        if (classType == Byte.TYPE || classType == Byte.class) {
            return new ArrayByte(index, (byte[])storage);
        }
        if (classType == Character.TYPE || classType == Character.class) {
            return new ArrayChar(index, (char[])storage);
        }
        if (classType == Boolean.TYPE || classType == Boolean.class) {
            return new ArrayBoolean(index, (boolean[])storage);
        }
        return new ArrayObject(classType, index, (Object[])storage);
    }

    private static Array factory(Class classType, Index index) {
        if (classType == Double.TYPE || classType == Double.class) {
            return ArrayDouble.factory(index);
        }
        if (classType == Float.TYPE || classType == Float.class) {
            return ArrayFloat.factory(index);
        }
        if (classType == Long.TYPE || classType == Long.class) {
            return ArrayLong.factory(index);
        }
        if (classType == Integer.TYPE || classType == Integer.class) {
            return ArrayInt.factory(index);
        }
        if (classType == Short.TYPE || classType == Short.class) {
            return ArrayShort.factory(index);
        }
        if (classType == Byte.TYPE || classType == Byte.class) {
            return ArrayByte.factory(index);
        }
        if (classType == Character.TYPE || classType == Character.class) {
            return ArrayChar.factory(index);
        }
        if (classType == Boolean.TYPE || classType == Boolean.class) {
            return ArrayBoolean.factory(index);
        }
        return ArrayObject.factory(classType, index);
    }

    public static Array factory(Class classType, int[] shape, Object storage) {
        Index indexCalc = Index.factory(shape);
        return Array.factory(classType, indexCalc, storage);
    }

    private static Array factory(Class classType, Index indexCalc, Object storage) {
        if (classType == Double.TYPE || classType == Double.class) {
            return ArrayDouble.factory(indexCalc, (double[])storage);
        }
        if (classType == Float.TYPE || classType == Float.class) {
            return ArrayFloat.factory(indexCalc, (float[])storage);
        }
        if (classType == Long.TYPE || classType == Long.class) {
            return ArrayLong.factory(indexCalc, (long[])storage);
        }
        if (classType == Integer.TYPE || classType == Integer.class) {
            return ArrayInt.factory(indexCalc, (int[])storage);
        }
        if (classType == Short.TYPE || classType == Short.class) {
            return ArrayShort.factory(indexCalc, (short[])storage);
        }
        if (classType == Byte.TYPE || classType == Byte.class) {
            return ArrayByte.factory(indexCalc, (byte[])storage);
        }
        if (classType == Character.TYPE || classType == Character.class) {
            return ArrayChar.factory(indexCalc, (char[])storage);
        }
        if (classType == Boolean.TYPE || classType == Boolean.class) {
            return ArrayBoolean.factory(indexCalc, (boolean[])storage);
        }
        return ArrayObject.factory(classType, indexCalc, (Object[])storage);
    }

    public static Array factory(Object javaArray) {
        int rank_ = 0;
        Class<?> componentType = javaArray.getClass();
        while (componentType.isArray()) {
            ++rank_;
            componentType = componentType.getComponentType();
        }
        int count = 0;
        int[] shape = new int[rank_];
        Object jArray = javaArray;
        Class<?> cType = jArray.getClass();
        while (cType.isArray()) {
            shape[count++] = java.lang.reflect.Array.getLength(jArray);
            jArray = java.lang.reflect.Array.get(jArray, 0);
            cType = jArray.getClass();
        }
        Array aa = Array.factory(componentType, shape);
        IndexIterator aaIter = aa.getIndexIterator();
        Array.reflectArrayCopyIn(javaArray, aa, aaIter);
        return aa;
    }

    private static void reflectArrayCopyIn(Object jArray, Array aa, IndexIterator aaIter) {
        Class<?> cType = jArray.getClass().getComponentType();
        if (cType.isPrimitive()) {
            aa.copyFrom1DJavaArray(aaIter, jArray);
        } else {
            for (int i = 0; i < java.lang.reflect.Array.getLength(jArray); ++i) {
                Array.reflectArrayCopyIn(java.lang.reflect.Array.get(jArray, i), aa, aaIter);
            }
        }
    }

    private static void reflectArrayCopyOut(Object jArray, Array aa, IndexIterator aaIter) {
        Class<?> cType = jArray.getClass().getComponentType();
        if (cType.isPrimitive()) {
            aa.copyTo1DJavaArray(aaIter, jArray);
        } else {
            for (int i = 0; i < java.lang.reflect.Array.getLength(jArray); ++i) {
                Array.reflectArrayCopyOut(java.lang.reflect.Array.get(jArray, i), aa, aaIter);
            }
        }
    }

    public static void arraycopy(Array arraySrc, int srcPos, Array arrayDst, int dstPos, int len) {
        System.arraycopy(arraySrc.getStorage(), srcPos, arrayDst.getStorage(), dstPos, len);
    }

    protected Array(int[] shape) {
        this.rank = shape.length;
        this.indexCalc = Index.factory(shape);
    }

    protected Array(Index index) {
        this.rank = index.getRank();
        this.indexCalc = index;
    }

    public Index getIndex() {
        return (Index)this.indexCalc.clone();
    }

    public IndexIterator getIndexIterator() {
        return this.indexCalc.getIndexIterator(this);
    }

    public int getRank() {
        return this.rank;
    }

    public int[] getShape() {
        return this.indexCalc.getShape();
    }

    public long getSize() {
        return this.indexCalc.getSize();
    }

    public IndexIterator getRangeIterator(List<Range> ranges) throws InvalidRangeException {
        return this.section(ranges).getIndexIterator();
    }

    public IndexIterator getIndexIteratorFast() {
        return this.indexCalc.getIndexIteratorFast(this);
    }

    public abstract Class getElementType();

    abstract Array createView(Index var1);

    public abstract Object getStorage();

    abstract void copyFrom1DJavaArray(IndexIterator var1, Object var2);

    abstract void copyTo1DJavaArray(IndexIterator var1, Object var2);

    public Array section(List<Range> ranges) throws InvalidRangeException {
        return this.createView(this.indexCalc.section(ranges));
    }

    public Array section(int[] origin, int[] shape) throws InvalidRangeException {
        return this.section(origin, shape, null);
    }

    public Array section(int[] origin, int[] shape, int[] stride) throws InvalidRangeException {
        int i;
        ArrayList<Range> ranges = new ArrayList<Range>(origin.length);
        if (stride == null) {
            stride = new int[origin.length];
            for (i = 0; i < stride.length; ++i) {
                stride[i] = 1;
            }
        }
        for (i = 0; i < origin.length; ++i) {
            ranges.add(new Range(origin[i], origin[i] + stride[i] * shape[i] - 1, stride[i]));
        }
        return this.createView(this.indexCalc.section(ranges));
    }

    public Array sectionNoReduce(List<Range> ranges) throws InvalidRangeException {
        return this.createView(this.indexCalc.sectionNoReduce(ranges));
    }

    public Array sectionNoReduce(int[] origin, int[] shape, int[] stride) throws InvalidRangeException {
        int i;
        ArrayList<Range> ranges = new ArrayList<Range>(origin.length);
        if (stride == null) {
            stride = new int[origin.length];
            for (i = 0; i < stride.length; ++i) {
                stride[i] = 1;
            }
        }
        for (i = 0; i < origin.length; ++i) {
            ranges.add(new Range(origin[i], origin[i] + stride[i] * shape[i] - 1, stride[i]));
        }
        return this.createView(this.indexCalc.sectionNoReduce(ranges));
    }

    public Array slice(int dim, int value) {
        int[] origin = new int[this.rank];
        int[] shape = this.getShape();
        origin[dim] = value;
        shape[dim] = 1;
        try {
            return this.sectionNoReduce(origin, shape, null).reduce(dim);
        }
        catch (InvalidRangeException e) {
            throw new IllegalArgumentException();
        }
    }

    public Array copy() {
        Array newA = Array.factory(this.getElementType(), this.getShape());
        MAMath.copy(newA, this);
        return newA;
    }

    public Object get1DJavaArray(Class wantType) {
        if (wantType == this.getElementType()) {
            if (this.indexCalc.fastIterator) {
                return this.getStorage();
            }
            return this.copyTo1DJavaArray();
        }
        Array newA = Array.factory(wantType, this.getShape());
        MAMath.copy(newA, this);
        return newA.getStorage();
    }

    public ByteBuffer getDataAsByteBuffer() {
        throw new UnsupportedOperationException();
    }

    public Object copyTo1DJavaArray() {
        Array newA = this.copy();
        return newA.getStorage();
    }

    public Object copyToNDJavaArray() {
        Object javaArray;
        try {
            javaArray = java.lang.reflect.Array.newInstance(this.getElementType(), this.getShape());
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
        IndexIterator iter = this.getIndexIterator();
        Array.reflectArrayCopyOut(javaArray, this, iter);
        return javaArray;
    }

    public Array flip(int dim) {
        return this.createView(this.indexCalc.flip(dim));
    }

    public Array transpose(int dim1, int dim2) {
        return this.createView(this.indexCalc.transpose(dim1, dim2));
    }

    public Array permute(int[] dims) {
        return this.createView(this.indexCalc.permute(dims));
    }

    public Array reshape(int[] shape) {
        Array result = Array.factory(this.getElementType(), shape);
        if (result.getSize() != this.getSize()) {
            throw new IllegalArgumentException("reshape arrays must have same total size");
        }
        Array.arraycopy(this, 0, result, 0, (int)this.getSize());
        return result;
    }

    public Array reduce() {
        return this.createView(this.indexCalc.reduce());
    }

    public Array reduce(int dim) {
        return this.createView(this.indexCalc.reduce(dim));
    }

    public void setIndexName(int dim, String indexName) {
        this.indexCalc.setIndexName(dim, indexName);
    }

    public String getIndexName(int dim) {
        return this.indexCalc.getIndexName(dim);
    }

    public abstract double getDouble(Index var1);

    public abstract void setDouble(Index var1, double var2);

    public abstract float getFloat(Index var1);

    public abstract void setFloat(Index var1, float var2);

    public abstract long getLong(Index var1);

    public abstract void setLong(Index var1, long var2);

    public abstract int getInt(Index var1);

    public abstract void setInt(Index var1, int var2);

    public abstract short getShort(Index var1);

    public abstract void setShort(Index var1, short var2);

    public abstract byte getByte(Index var1);

    public abstract void setByte(Index var1, byte var2);

    public abstract char getChar(Index var1);

    public abstract void setChar(Index var1, char var2);

    public abstract boolean getBoolean(Index var1);

    public abstract void setBoolean(Index var1, boolean var2);

    public abstract Object getObject(Index var1);

    public abstract void setObject(Index var1, Object var2);

    abstract double getDouble(int var1);

    abstract void setDouble(int var1, double var2);

    abstract float getFloat(int var1);

    abstract void setFloat(int var1, float var2);

    abstract long getLong(int var1);

    abstract void setLong(int var1, long var2);

    abstract int getInt(int var1);

    abstract void setInt(int var1, int var2);

    abstract short getShort(int var1);

    abstract void setShort(int var1, short var2);

    abstract byte getByte(int var1);

    abstract void setByte(int var1, byte var2);

    abstract char getChar(int var1);

    abstract void setChar(int var1, char var2);

    abstract boolean getBoolean(int var1);

    abstract void setBoolean(int var1, boolean var2);

    abstract Object getObject(int var1);

    abstract void setObject(int var1, Object var2);

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        IndexIterator ii = this.getIndexIterator();
        while (ii.hasNext()) {
            Object data = ii.getObjectNext();
            sbuff.append(data);
            sbuff.append(" ");
        }
        return sbuff.toString();
    }

    public String shapeToString() {
        int[] shape = this.getShape();
        if (shape.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < shape.length; ++i) {
            int s = shape[i];
            if (i > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean hasNext() {
        if (null == this.ii) {
            this.ii = this.getIndexIterator();
        }
        return this.ii.hasNext();
    }

    public Object next() {
        return this.ii.getObjectNext();
    }

    public void resetLocalIterator() {
        this.ii = null;
    }
}

