/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.ProxyReader;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhanceScaleMissingImpl;
import ucar.nc2.dataset.EnhancementsImpl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableDS
extends Variable
implements VariableEnhanced {
    private EnhancementsImpl proxy;
    private EnhanceScaleMissingImpl smProxy;
    private boolean isEnhanced;
    protected Variable orgVar;
    private DataType orgDataType;

    public VariableDS(NetcdfDataset ds, Group group, Structure parentStructure, String shortName, DataType dataType, String dims, String units, String desc) {
        super(ds, group, parentStructure, shortName);
        this.setDataType(dataType);
        this.setDimensions(dims);
        this.orgDataType = dataType;
        if (dataType == DataType.STRUCTURE) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + shortName);
        }
        if (units != null) {
            this.addAttribute(new Attribute("units", units));
        }
        if (desc != null) {
            this.addAttribute(new Attribute("long_name", desc));
        }
        this.proxy = new EnhancementsImpl(this, units, desc);
        this.smProxy = new EnhanceScaleMissingImpl();
    }

    public VariableDS(Group g, Variable orgVar, boolean enhance) {
        super(orgVar);
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getName());
        }
        this.ncfile = null;
        this.spiObject = null;
        this.preReader = null;
        this.postReader = null;
        this.createNewCache();
        this.orgVar = orgVar;
        this.orgDataType = orgVar.getDataType();
        if (g != null) {
            this.group = g;
        }
        if (orgVar instanceof VariableDS) {
            VariableDS ncVarDS = (VariableDS)orgVar;
        }
        this.proxy = new EnhancementsImpl(this);
        if (enhance) {
            this.enhance();
        } else {
            this.smProxy = new EnhanceScaleMissingImpl();
        }
    }

    protected VariableDS(VariableDS vds) {
        super(vds);
        this.isEnhanced = vds.isEnhanced;
        this.orgVar = vds.orgVar;
        this.orgDataType = vds.orgDataType;
        this.smProxy = vds.smProxy;
        this.proxy = new EnhancementsImpl(this);
    }

    @Override
    protected Variable copy() {
        return new VariableDS(this);
    }

    @Override
    public void enhance() {
        this.smProxy = new EnhanceScaleMissingImpl(this);
        if (this.smProxy.hasScaleOffset() && this.smProxy.getConvertedDataType() != this.getDataType()) {
            this.setDataType(this.smProxy.getConvertedDataType());
        }
        this.isEnhanced = true;
    }

    public boolean isEnhanced() {
        return this.isEnhanced;
    }

    @Override
    public boolean isCoordinateVariable() {
        return this instanceof CoordinateAxis || super.isCoordinateVariable();
    }

    @Override
    public void addCoordinateSystem(CoordinateSystem p0) {
        this.proxy.addCoordinateSystem(p0);
    }

    @Override
    public void removeCoordinateSystem(CoordinateSystem p0) {
        this.proxy.removeCoordinateSystem(p0);
    }

    @Override
    public List<CoordinateSystem> getCoordinateSystems() {
        return this.proxy.getCoordinateSystems();
    }

    @Override
    public String getDescription() {
        return this.proxy.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.proxy.getUnitsString();
    }

    public void setUnitsString(String units) {
        this.proxy.setUnitsString(units);
    }

    @Override
    public double getValidMax() {
        return this.smProxy.getValidMax();
    }

    @Override
    public double getValidMin() {
        return this.smProxy.getValidMin();
    }

    @Override
    public boolean hasFillValue() {
        return this.smProxy.hasFillValue();
    }

    @Override
    public boolean hasInvalidData() {
        return this.smProxy.hasInvalidData();
    }

    @Override
    public boolean hasMissing() {
        return this.smProxy.hasMissing();
    }

    @Override
    public boolean hasMissingValue() {
        return this.smProxy.hasMissingValue();
    }

    @Override
    public boolean hasScaleOffset() {
        return this.smProxy.hasScaleOffset();
    }

    @Override
    public boolean isFillValue(double p0) {
        return this.smProxy.isFillValue(p0);
    }

    @Override
    public boolean isInvalidData(double p0) {
        return this.smProxy.isInvalidData(p0);
    }

    @Override
    public boolean isMissing(double p0) {
        return this.smProxy.isMissing(p0);
    }

    @Override
    public boolean isMissingValue(double p0) {
        return this.smProxy.isMissingValue(p0);
    }

    @Override
    public void setFillValueIsMissing(boolean p0) {
        this.smProxy.setFillValueIsMissing(p0);
    }

    @Override
    public void setInvalidDataIsMissing(boolean p0) {
        this.smProxy.setInvalidDataIsMissing(p0);
    }

    @Override
    public void setMissingDataIsMissing(boolean p0) {
        this.smProxy.setMissingDataIsMissing(p0);
    }

    @Override
    public void setUseNaNs(boolean useNaNs) {
        this.smProxy.setUseNaNs(useNaNs);
    }

    @Override
    public double convertScaleOffsetMissing(byte value) {
        return this.smProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(short value) {
        return this.smProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(int value) {
        return this.smProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(long value) {
        return this.smProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public double convertScaleOffsetMissing(double value) {
        return this.smProxy.convertScaleOffsetMissing(value);
    }

    @Override
    public Variable getOriginalVariable() {
        return this.orgVar;
    }

    @Override
    public void setOriginalVariable(Variable orgVar) {
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getName());
        }
        this.orgVar = orgVar;
    }

    public DataType getOriginalDataType() {
        return this.orgDataType;
    }

    @Override
    public void setProxyReader(ProxyReader proxyReader) {
        this.postReader = proxyReader;
    }

    @Override
    public ProxyReader getProxyReader() {
        return this.postReader;
    }

    @Override
    public String toStringDebug() {
        return this.orgVar != null ? this.orgVar.toStringDebug() : "";
    }

    @Override
    protected Array _read() throws IOException {
        Array result;
        if (this.preReader != null) {
            return this.preReader.read(this, null);
        }
        if (this.hasCachedData()) {
            result = super._read();
        } else if (this.postReader != null) {
            result = this.postReader.read(this, null);
        } else if (this.orgVar != null) {
            result = this.orgVar.read();
        } else {
            Object data = this.smProxy.getFillValue(this.getDataType());
            return Array.factoryConstant(this.dataType.getPrimitiveClassType(), this.getShape(), data);
        }
        if (this.smProxy.hasScaleOffset()) {
            result = this.smProxy.convertScaleOffset(result);
        } else if (this.smProxy.hasMissing() && this.smProxy.getUseNaNs()) {
            result = this.smProxy.convertMissing(result);
        }
        return result;
    }

    @Override
    protected Array _read(Section section) throws IOException, InvalidRangeException {
        Array result;
        if (this.preReader != null) {
            return this.preReader.read(this, section, null);
        }
        if (this.hasCachedData()) {
            result = super._read(section);
        } else if (this.postReader != null) {
            result = this.postReader.read(this, section, null);
        } else if (this.orgVar != null) {
            result = this.orgVar.read(section);
        } else {
            Object data = this.smProxy.getFillValue(this.getDataType());
            return Array.factoryConstant(this.dataType.getPrimitiveClassType(), section.getShape(), data);
        }
        if (this.smProxy.hasScaleOffset()) {
            result = this.smProxy.convertScaleOffset(result);
        } else if (this.smProxy.hasMissing() && this.smProxy.getUseNaNs()) {
            result = this.smProxy.convertMissing(result);
        }
        return result;
    }

    @Override
    protected Array _readMemberData(Section section, boolean flatten) throws IOException, InvalidRangeException {
        Array result = super._readMemberData(section, flatten);
        return result;
    }

    public String getUnitString() {
        return this.getUnitsString();
    }
}

