/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import thredds.catalog.DataType;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.EarthLocation;
import ucar.nc2.dt.EarthLocationImpl;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.VariableSimpleAdapter;
import ucar.nc2.dt.radial.RadialCoordSys;
import ucar.nc2.dt.radial.RadialDatasetSweepAdapter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class Dorade2Dataset
extends RadialDatasetSweepAdapter
implements TypedDatasetFactoryIF {
    protected DateUnit dateUnits;
    private NetcdfDataset ncd;
    float[] elev;
    float[] aziv;
    float[] disv;
    float[] lonv;
    float[] altv;
    float[] latv;
    double[] timv;
    float ranv;
    float cellv;
    float angv;
    float nyqv;
    float rangv;
    float contv;
    float rgainv;
    float bwidthv;

    public boolean isMine(NetcdfDataset ds) {
        String format;
        String convention = ds.findAttValueIgnoreCase(null, "Conventions", null);
        return null != convention && convention.equals("_Coordinates") && (format = ds.findAttValueIgnoreCase(null, "Format", null)).equals("Unidata/netCDF/Dorade");
    }

    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuffer errlog) throws IOException {
        return new Dorade2Dataset(ncd);
    }

    public DataType getScientificDataType() {
        return DataType.RADIAL;
    }

    public Dorade2Dataset() {
    }

    public Dorade2Dataset(NetcdfDataset ds) {
        super(ds);
        this.ncd = ds;
        this.desc = "dorade radar dataset";
        try {
            this.elev = (float[])this.ncd.findVariable("elevation").read().get1DJavaArray(Float.TYPE);
            this.aziv = (float[])this.ncd.findVariable("azimuth").read().get1DJavaArray(Float.TYPE);
            this.altv = (float[])this.ncd.findVariable("altitudes_1").read().get1DJavaArray(Float.TYPE);
            this.lonv = (float[])this.ncd.findVariable("longitudes_1").read().get1DJavaArray(Float.TYPE);
            this.latv = (float[])this.ncd.findVariable("latitudes_1").read().get1DJavaArray(Float.TYPE);
            this.disv = (float[])this.ncd.findVariable("distance_1").read().get1DJavaArray(Float.TYPE);
            this.timv = (double[])this.ncd.findVariable("rays_time").read().get1DJavaArray(Double.TYPE);
            this.angv = this.ncd.findVariable("Fixed_Angle").readScalarFloat();
            this.nyqv = this.ncd.findVariable("Nyquist_Velocity").readScalarFloat();
            this.rangv = this.ncd.findVariable("Unambiguous_Range").readScalarFloat();
            this.contv = this.ncd.findVariable("Radar_Constant").readScalarFloat();
            this.rgainv = this.ncd.findVariable("rcvr_gain").readScalarFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setStartDate();
        this.setEndDate();
    }

    public String getRadarID() {
        return this.ncd.findGlobalAttribute("radar_name").getStringValue();
    }

    public String getRadarName() {
        return "Dorade Radar";
    }

    public String getDataFormat() {
        return "DORADE";
    }

    public EarthLocation getCommonOrigin() {
        if (this.isStationary()) {
            return new EarthLocationImpl(this.latv[0], this.lonv[0], this.elev[0]);
        }
        return null;
    }

    public boolean isStationary() {
        String t = this.ncd.findGlobalAttribute("IsStationary").getStringValue();
        return t.equals("1");
    }

    public boolean isVolume() {
        return false;
    }

    protected void setEarthLocation() {
        if (this.isStationary()) {
            this.origin = new EarthLocationImpl(this.latv[0], this.lonv[0], this.elev[0]);
        }
        this.origin = null;
    }

    protected RadialDatasetSweep.RadialVariable makeRadialVariable(VariableEnhanced varDS, RadialCoordSys gcs) {
        return new Dorade2Variable(varDS, gcs);
    }

    public List getDataVariables() {
        return this.dataVariables;
    }

    protected void setStartDate() {
        Date da = new Date((long)this.timv[0]);
        String start_datetime = da.toString();
        if (start_datetime != null) {
            this.startDate = da;
        } else {
            this.parseInfo.append("*** start_datetime not Found\n");
        }
    }

    protected void setEndDate() {
        Date da = new Date((long)this.timv[this.timv.length - 1]);
        String end_datetime = da.toString();
        if (end_datetime != null) {
            this.endDate = da;
        } else {
            this.parseInfo.append("*** end_datetime not Found\n");
        }
    }

    protected void setTimeUnits() {
        List<CoordinateAxis> axes = this.ncd.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = axes.get(i);
            if (axis.getAxisType() != AxisType.Time) continue;
            String units = axis.getUnitsString();
            this.dateUnits = (DateUnit)SimpleUnit.factory(units);
            return;
        }
        this.parseInfo.append("*** Time Units not Found\n");
    }

    public VariableSimpleIF getDataVariable(String name) {
        CoordinateSystem cs;
        VariableEnhanced c = (VariableEnhanced)((Object)this.ncd.findVariable(name));
        RadialCoordSys rcs = null;
        List<CoordinateSystem> csys = c.getCoordinateSystems();
        for (int j = 0; j < csys.size() && (rcs = RadialCoordSys.makeRadialCoordSys(this.parseInfo, cs = csys.get(j), c)) == null; ++j) {
        }
        if (rcs != null) {
            return this.makeRadialVariable(c, rcs);
        }
        return null;
    }

    public List getAttributes() {
        return this.ncd.getRootGroup().getAttributes();
    }

    public DateUnit getTimeUnits() {
        return this.dateUnits;
    }

    public void getTimeUnits(DateUnit dateUnits) {
        this.dateUnits = dateUnits;
    }

    public void clearDatasetMemory() {
        List rvars = this.getDataVariables();
        for (RadialDatasetSweep.RadialVariable radVar : rvars) {
            radVar.clearVariableMemory();
        }
    }

    private static void testRadialVariable(RadialDatasetSweep.RadialVariable rv) throws IOException {
        int nsweep = rv.getNumSweeps();
        if (nsweep != 1) {
            // empty if block
        }
        RadialDatasetSweep.Sweep sw = rv.getSweep(1);
        int nrays = sw.getRadialNumber();
        float[] ddd = sw.readData();
        for (int i = 0; i < nrays; ++i) {
            int ngates = sw.getGateNumber();
            float[] d = sw.readData(i);
            float azi = sw.getAzimuth(i);
            float ele = sw.getElevation(i);
            double t = sw.getTime(i);
            Date da = new Date((long)t);
            String start_datetime = da.toString();
            float dis = sw.getRangeToFirstGate();
            float beamW = sw.getBeamWidth();
            float gsize = sw.getGateSize();
            float la = (float)sw.getOrigin(i).getLatitude();
            float lo = (float)sw.getOrigin(i).getLongitude();
            float al = (float)sw.getOrigin(i).getAltitude();
        }
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "/home/yuanho/dorade/swp.1020511015815.SP0L.573.1.2_SUR_v1";
        RadialDatasetSweep rds = (RadialDatasetSweep)TypedDatasetFactory.open(DataType.RADIAL, fileIn, null, new StringBuffer());
        String st = rds.getStartDate().toString();
        String et = rds.getEndDate().toString();
        if (rds.isStationary()) {
            System.out.println("*** radar is stationary\n");
        }
        List<VariableSimpleIF> rvars = rds.getDataVariables();
        RadialDatasetSweep.RadialVariable vDM = (RadialDatasetSweep.RadialVariable)rds.getDataVariable("DM");
        Dorade2Dataset.testRadialVariable(vDM);
        for (int i = 0; i < rvars.size(); ++i) {
            RadialDatasetSweep.RadialVariable rv = (RadialDatasetSweep.RadialVariable)rvars.get(i);
            Dorade2Dataset.testRadialVariable(rv);
        }
    }

    private class Dorade2Variable
    extends VariableSimpleAdapter
    implements RadialDatasetSweep.RadialVariable {
        protected RadialCoordSys radialCoordsys;
        protected VariableEnhanced ve;
        int nrays;
        int ngates;
        float ele;
        float azi;
        float alt;
        float lon;
        float lat;
        RadialDatasetSweep.Sweep sweep;

        public int getNumSweeps() {
            return 1;
        }

        public RadialDatasetSweep.Sweep getSweep(int nsw) {
            if (this.sweep == null) {
                this.sweep = new Dorade2Sweep();
            }
            return this.sweep;
        }

        private Dorade2Variable(VariableEnhanced v, RadialCoordSys rcys) {
            super(v);
            this.ve = v;
            this.radialCoordsys = rcys;
            int[] shape = v.getShape();
            int count = v.getRank() - 1;
            this.ngates = shape[count];
            this.nrays = shape[--count];
        }

        public int getNumRadials() {
            return this.nrays;
        }

        public float[] readAllData() throws IOException {
            Array allData;
            try {
                allData = this.ve.read();
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            return (float[])allData.get1DJavaArray(Float.TYPE);
        }

        public void clearVariableMemory() {
        }

        private class Dorade2Sweep
        implements RadialDatasetSweep.Sweep {
            double meanElevation = Double.NaN;

            Dorade2Sweep() {
            }

            public RadialDatasetSweep.Type getType() {
                return null;
            }

            public float getLon(int ray) {
                return Dorade2Dataset.this.lonv[ray];
            }

            public int getGateNumber() {
                return Dorade2Variable.this.ngates;
            }

            public int getRadialNumber() {
                return Dorade2Variable.this.nrays;
            }

            public int getSweepIndex() {
                return 0;
            }

            public float[] readData() throws IOException {
                return Dorade2Variable.this.readAllData();
            }

            public float[] readData(int ray) throws IOException {
                Array rayData;
                int[] shape = Dorade2Variable.this.ve.getShape();
                int[] origi = new int[Dorade2Variable.this.ve.getRank()];
                shape[0] = 1;
                origi[0] = ray;
                try {
                    rayData = Dorade2Variable.this.ve.read(origi, shape);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e.getMessage());
                }
                return (float[])rayData.get1DJavaArray(Float.TYPE);
            }

            public float getBeamWidth() {
                try {
                    Dorade2Dataset.this.bwidthv = Dorade2Dataset.this.ncd.findVariable("bm_width").readScalarFloat();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return Dorade2Dataset.this.bwidthv;
            }

            public float getNyquistFrequency() {
                return 0.0f;
            }

            public float getRangeToFirstGate() {
                try {
                    Dorade2Dataset.this.ranv = Dorade2Dataset.this.ncd.findVariable("Range_to_First_Cell").readScalarFloat();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return Dorade2Dataset.this.ranv;
            }

            public float getGateSize() {
                try {
                    Dorade2Dataset.this.cellv = Dorade2Dataset.this.ncd.findVariable("Cell_Spacing").readScalarFloat();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return Dorade2Dataset.this.cellv;
            }

            public float getMeanElevation() {
                int[] shapeRadial = new int[]{Dorade2Variable.this.nrays};
                Array data = Array.factory(Float.class, shapeRadial, (Object)Dorade2Dataset.this.elev);
                this.meanElevation = MAMath.sumDouble(data) / (double)data.getSize();
                return (float)this.meanElevation;
            }

            public float getElevation(int ray) {
                return Dorade2Dataset.this.elev[ray];
            }

            public float[] getElevation() {
                return Dorade2Dataset.this.elev;
            }

            public float getAzimuth(int ray) {
                return Dorade2Dataset.this.aziv[ray];
            }

            public float[] getAzimuth() {
                return Dorade2Dataset.this.aziv;
            }

            public float getTime() {
                return (float)Dorade2Dataset.this.timv[0];
            }

            public float getTime(int ray) {
                return (float)Dorade2Dataset.this.timv[ray];
            }

            public EarthLocation getOrigin(int ray) {
                return new EarthLocationImpl(Dorade2Dataset.this.latv[ray], Dorade2Dataset.this.lonv[ray], Dorade2Dataset.this.altv[ray]);
            }

            public float getMeanAzimuth() {
                if (this.getType() != null) {
                    return Dorade2Variable.this.azi;
                }
                return 0.0f;
            }

            public Date getStartingTime() {
                return Dorade2Dataset.this.startDate;
            }

            public Date getEndingTime() {
                return Dorade2Dataset.this.endDate;
            }

            public void clearSweepMemory() {
            }
        }
    }
}

