/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import loci.poi.poifs.property.Property;
import loci.poi.poifs.storage.BigBlock;
import loci.poi.poifs.storage.BlockWritable;

public class PropertyBlock
extends BigBlock {
    private Property[] _properties;
    private int _properties_per_block;
    private int blockSize;

    private PropertyBlock(Property[] properties, int offset, int blockSize) {
        this.blockSize = blockSize;
        this._properties_per_block = blockSize / 128;
        this._properties = new Property[this._properties_per_block];
        for (int j = 0; j < this._properties_per_block; ++j) {
            this._properties[j] = properties[j + offset];
        }
    }

    public int getBigBlockSize() {
        return this.blockSize;
    }

    public static BlockWritable[] createPropertyBlockArray(List properties, int size) {
        int block_count = (properties.size() + size / 128 - 1) / (size / 128);
        Property[] to_be_written = new Property[block_count * (size / 128)];
        System.arraycopy(properties.toArray(new Property[0]), 0, to_be_written, 0, properties.size());
        for (int j = properties.size(); j < to_be_written.length; ++j) {
            to_be_written[j] = new Property(){

                protected void preWrite() {
                }

                public boolean isDirectory() {
                    return false;
                }
            };
        }
        BlockWritable[] rvalue = new BlockWritable[block_count];
        for (int j = 0; j < block_count; ++j) {
            rvalue[j] = new PropertyBlock(to_be_written, j * (size / 128), size);
        }
        return rvalue;
    }

    void writeData(OutputStream stream) throws IOException {
        for (int j = 0; j < this._properties_per_block; ++j) {
            this._properties[j].writeData(stream);
        }
    }
}

