/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.dqc.Description;
import thredds.dqc.Selection;

public abstract class Selector {
    private static Logger log = LoggerFactory.getLogger(Selector.class);
    protected String id = null;
    protected String title = null;
    protected String template = null;
    protected boolean required = true;
    protected boolean multiple = false;
    protected Description description = null;

    protected Selector() {
    }

    protected Selector(String id, String title, String template, boolean required, boolean multiple, Description description) {
        this.id = id;
        this.title = title;
        this.template = template;
        this.required = required;
        this.multiple = multiple;
        this.description = description;
    }

    protected Selector(String id, String title, String template, Description description) {
        this.id = id;
        this.title = title;
        this.template = template;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTemplate() {
        return this.template;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public Description getDescription() {
        return this.description;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void setTemplate(String template) {
        this.template = template;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setDescription(String description) {
        this.description = new Description(description);
    }

    public abstract Selection validateSelection(Selection var1);
}

