/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IOServiceProviderWriter;
import ucar.nc2.iosp.netcdf3.SPFactory;
import ucar.unidata.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetcdfFileWriteable
extends NetcdfFile {
    private HashMap<String, Variable> varHash = new HashMap(50);
    private boolean defineMode;
    private boolean fill = true;
    private long size = -1L;
    private IOServiceProviderWriter spiw;

    public static NetcdfFileWriteable openExisting(String location) throws IOException {
        return NetcdfFileWriteable.openExisting(location, true);
    }

    public static NetcdfFileWriteable openExisting(String location, boolean fill) throws IOException {
        NetcdfFileWriteable result = new NetcdfFileWriteable(location);
        result.setFill(fill);
        return result;
    }

    public static NetcdfFileWriteable createNew(String location) {
        return NetcdfFileWriteable.createNew(location, true);
    }

    public static NetcdfFileWriteable createNew(String location, boolean fill) {
        return new NetcdfFileWriteable(location, fill);
    }

    public void setFill(boolean fill) {
        this.fill = fill;
        if (this.spiw != null) {
            this.spiw.setFill(fill);
        }
    }

    public void setLength(long size) {
        this.size = size;
    }

    public Dimension addDimension(String dimName, int length) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("length must be > 0");
        }
        Dimension dim = new Dimension(dimName, length, true, false, false);
        super.addDimension(null, dim);
        return dim;
    }

    public Dimension addDimension(String dimName, int length, boolean isShared, boolean isUnlimited, boolean isVariableLength) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Dimension dim = new Dimension(dimName, length, isShared, isUnlimited, isVariableLength);
        super.addDimension(null, dim);
        return dim;
    }

    public Dimension addUnlimitedDimension(String dimName) {
        return this.addDimension(dimName, 0, true, true, false);
    }

    public void addGlobalAttribute(Attribute att) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        super.addAttribute(null, att);
    }

    public void addGlobalAttribute(String name, String value) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        super.addAttribute(null, new Attribute(name, value));
    }

    public void addGlobalAttribute(String name, Number value) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        super.addAttribute(null, new Attribute(name, value));
    }

    public void addGlobalAttribute(String name, Array values) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        super.addAttribute(null, new Attribute(name, values));
    }

    public Variable addVariable(String varName, DataType dataType, Dimension[] dims) {
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        for (Dimension dim : dims) {
            list.add(dim);
        }
        return this.addVariable(varName, dataType, list);
    }

    public Variable addVariable(String varName, DataType dataType, String dims) {
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        StringTokenizer stoker = new StringTokenizer(dims);
        while (stoker.hasMoreTokens()) {
            String tok = stoker.nextToken();
            Dimension d = this.rootGroup.findDimension(tok);
            if (null == d) {
                throw new IllegalArgumentException("Canat find dimension " + tok);
            }
            list.add(d);
        }
        return this.addVariable(varName, dataType, list);
    }

    public Variable addVariable(String varName, DataType dataType, List<Dimension> dims) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Variable v = new Variable(this, this.rootGroup, null, varName);
        v.setDataType(dataType);
        v.setDimensions(dims);
        this.varHash.put(varName, v);
        super.addVariable(null, v);
        return v;
    }

    public Variable addStringVariable(String varName, List<Dimension> dims, int max_strlen) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Variable v = new Variable(this, this.rootGroup, null, varName);
        v.setDataType(DataType.CHAR);
        Dimension d = this.addDimension(varName + "_strlen", max_strlen);
        ArrayList<Dimension> sdims = new ArrayList<Dimension>(dims);
        sdims.add(d);
        v.setDimensions(sdims);
        this.varHash.put(varName, v);
        super.addVariable(null, v);
        return v;
    }

    public void addVariableAttribute(String varName, Attribute att) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Variable v = this.varHash.get(varName);
        if (null == v) {
            throw new IllegalArgumentException("addVariableAttribute variable name not found = <" + varName + ">");
        }
        v.addAttribute(att);
    }

    public void addVariableAttribute(String varName, String attName, String value) {
        this.addVariableAttribute(varName, new Attribute(attName, value));
    }

    public void addVariableAttribute(String varName, String attName, Number value) {
        this.addVariableAttribute(varName, new Attribute(attName, value));
    }

    public void addVariableAttribute(String varName, String attName, Array value) {
        Attribute att = new Attribute(attName, value);
        this.addVariableAttribute(varName, att);
    }

    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        this.spiw.updateAttribute(v2, att);
    }

    public void create() throws IOException {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.spi = SPFactory.getServiceProvider();
        this.spiw = (IOServiceProviderWriter)this.spi;
        this.spiw.create(this.location, this, this.fill, this.size);
        this.defineMode = false;
    }

    public boolean isDefineMode() {
        return this.defineMode;
    }

    public void write(String varName, Array values) throws IOException, InvalidRangeException {
        this.write(varName, new int[values.getRank()], values);
    }

    public void write(String varName, int[] origin, Array values) throws IOException, InvalidRangeException {
        if (this.defineMode) {
            throw new UnsupportedOperationException("in define mode");
        }
        Variable v2 = this.findVariable(varName);
        if (v2 == null) {
            throw new IllegalArgumentException("NetcdfFileWriteable.write illegal variable name = " + varName);
        }
        this.spiw.writeData(v2, new Section(origin, values.getShape()), values);
        v2.invalidateCache();
    }

    public void writeStringData(String varName, Array values) throws IOException, InvalidRangeException {
        this.writeStringData(varName, new int[values.getRank()], values);
    }

    public void writeStringData(String varName, int[] origin, Array values) throws IOException, InvalidRangeException {
        if (values.getElementType() != String.class) {
            throw new IllegalArgumentException("Must be ArrayObject of String ");
        }
        Variable v2 = this.findVariable(varName);
        if (v2 == null) {
            throw new IllegalArgumentException("illegal variable name = " + varName);
        }
        if (v2.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("variable " + varName + " is not type CHAR");
        }
        int rank = v2.getRank();
        int strlen = v2.shape[rank - 1];
        ArrayChar cvalues = ArrayChar.makeFromStringArray((ArrayObject)values, strlen);
        int[] corigin = new int[rank];
        System.arraycopy(origin, 0, corigin, 0, rank - 1);
        this.write(varName, corigin, cvalues);
    }

    public void flush() throws IOException {
        this.spiw.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.spiw.close();
        this.isClosed = true;
    }

    public NetcdfFileWriteable(String location, boolean fill) {
        this.location = location;
        this.fill = fill;
        this.defineMode = true;
    }

    public NetcdfFileWriteable() {
        this.defineMode = true;
    }

    public NetcdfFileWriteable(String location) throws IOException {
        this.location = location;
        RandomAccessFile raf = new RandomAccessFile(location, "rw");
        this.spi = SPFactory.getServiceProvider();
        this.spiw = (IOServiceProviderWriter)this.spi;
        this.spiw.open(raf, this, null);
        this.defineMode = false;
    }

    public void setName(String filename) {
        this.location = filename;
    }

    public Variable addVariable(String varName, Class componentType, Dimension[] dims) {
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        for (Dimension dim : dims) {
            list.add(dim);
        }
        return this.addVariable(varName, DataType.getType(componentType), list);
    }
}

