/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml4;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.ncml4.Aggregation;
import ucar.nc2.ncml4.AggregationOuterDimension;
import ucar.nc2.ncml4.NcMLReader;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.xml.Parse;

public class AggregationExisting
extends AggregationOuterDimension {
    private boolean debugPersist = false;
    private boolean debugPersistDetail = false;

    public AggregationExisting(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, AggregationIF.Type.JOIN_EXISTING, recheckS);
    }

    protected void buildDataset(CancelTask cancelTask) throws IOException {
        this.buildCoords(cancelTask);
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typical = typicalDataset.acquireFile(null);
        DatasetConstructor.transferDataset(typical, this.ncDataset, null);
        String dimName = this.getDimensionName();
        Dimension aggDim = new Dimension(dimName, this.getTotalCoords());
        this.ncDataset.removeDimension(null, dimName);
        this.ncDataset.addDimension(null, aggDim);
        this.promoteGlobalAttributes((AggregationOuterDimension.DatasetOuterDimension)typicalDataset);
        for (Variable v : typical.getVariables()) {
            Dimension d;
            if (v.getRank() < 1 || !dimName.equals((d = v.getDimension(0)).getName())) continue;
            VariableDS vagg = new VariableDS(this.ncDataset, null, null, v.getShortName(), v.getDataType(), v.getDimensionsString(), null, null);
            vagg.setProxyReader(this);
            DatasetConstructor.transferVariableAttributes(v, vagg);
            this.ncDataset.removeVariable(null, v.getShortName());
            this.ncDataset.addVariable(null, vagg);
            this.aggVars.add(vagg);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        VariableDS joinAggCoord = (VariableDS)this.ncDataset.getRootGroup().findVariable(dimName);
        if (joinAggCoord == null) {
            throw new IllegalArgumentException("No existing coordinate variable for joinExisting on " + this.getLocation());
        }
        if (this.type == AggregationIF.Type.JOIN_EXISTING_ONE) {
            joinAggCoord.setDataType(DataType.STRING);
            joinAggCoord.getAttributes().clear();
            joinAggCoord.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
            joinAggCoord.addAttribute(new Attribute("long_name", "time coordinate"));
            joinAggCoord.addAttribute(new Attribute("standard_name", "time"));
        }
        if (this.timeUnitsChange) {
            this.readTimeCoordinates(joinAggCoord, cancelTask);
        }
        AggregationOuterDimension.CoordValueVar cv = new AggregationOuterDimension.CoordValueVar((AggregationOuterDimension)this, joinAggCoord);
        joinAggCoord.setSPobject(cv);
        this.cacheList.add(cv);
        this.setDatasetAcquireProxy(typicalDataset, this.ncDataset);
        typicalDataset.close(typical);
    }

    protected void rebuildDataset() throws IOException {
        super.rebuildDataset();
        if (this.timeUnitsChange) {
            VariableDS joinAggCoord = (VariableDS)this.ncDataset.getRootGroup().findVariable(this.dimName);
            this.readTimeCoordinates(joinAggCoord, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTimeCoordinates(VariableDS timeAxis, CancelTask cancelTask) throws IOException {
        ArrayList<Date> dateList = new ArrayList<Date>();
        String units = null;
        for (Aggregation.Dataset dataset : this.getDatasets()) {
            NetcdfDataset ncfile = null;
            try {
                Date[] dates;
                ncfile = (NetcdfDataset)dataset.acquireFile(cancelTask);
                VariableDS v = (VariableDS)ncfile.findVariable(timeAxis.getName());
                if (v == null) {
                    logger.warn("readTimeCoordinates: variable = " + timeAxis.getName() + " not found in file " + dataset.getLocation());
                    return;
                }
                CoordinateAxis1DTime timeCoordVar = CoordinateAxis1DTime.factory(this.ncDataset, v, null);
                for (Date d : dates = timeCoordVar.getTimeDates()) {
                    dateList.add(d);
                }
                if (units == null) {
                    units = v.getUnitsString();
                }
            }
            finally {
                dataset.close(ncfile);
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        int[] shape = timeAxis.getShape();
        int ntimes = shape[0];
        assert (ntimes == dateList.size());
        Array timeCoordVals = Array.factory(timeAxis.getDataType(), shape);
        IndexIterator ii = timeCoordVals.getIndexIterator();
        timeAxis.setCachedData(timeCoordVals, false);
        if (timeAxis.getDataType() == DataType.STRING) {
            for (Date date : dateList) {
                ii.setObjectNext(this.formatter.toDateTimeStringISO(date));
            }
        } else {
            DateUnit du;
            try {
                du = new DateUnit(units);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            timeAxis.addAttribute(new Attribute("units", units));
            for (Date date : dateList) {
                double val = du.makeValue(date);
                ii.setDoubleNext(val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() throws IOException {
        if (diskCache2 == null) {
            return;
        }
        if (!this.cacheDirty) {
            return;
        }
        AbstractInterruptibleChannel channel = null;
        try {
            FileLock lock;
            String cacheName = this.getCacheName();
            if (cacheName == null) {
                return;
            }
            File cacheFile = diskCache2.getCacheFile(cacheName);
            boolean exists = cacheFile.exists();
            if (!exists) {
                File dir = cacheFile.getParentFile();
                dir.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(cacheFile);
            channel = fos.getChannel();
            try {
                lock = ((FileChannel)channel).tryLock();
            }
            catch (OverlappingFileLockException e) {
                if (channel != null) {
                    channel.close();
                }
                return;
            }
            if (lock == null) {
                return;
            }
            PrintStream out = new PrintStream(fos);
            out.print("<?xml version='1.0' encoding='UTF-8'?>\n");
            out.print("<aggregation xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2' ");
            out.print("type='" + this.type + "' ");
            if (this.dimName != null) {
                out.print("dimName='" + this.dimName + "' ");
            }
            if (this.datasetManager.getRecheck() != null) {
                out.print("recheckEvery='" + this.datasetManager.getRecheck() + "' ");
            }
            out.print(">\n");
            List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
            for (Aggregation.Dataset dataset : nestedDatasets) {
                AggregationOuterDimension.DatasetOuterDimension dod = (AggregationOuterDimension.DatasetOuterDimension)dataset;
                out.print("  <netcdf location='" + dataset.getLocation() + "' ");
                out.print("ncoords='" + dod.getNcoords(null) + "' ");
                if (dod.coordValue != null) {
                    out.print("coordValue='" + dod.coordValue + "' ");
                }
                out.print("/>\n");
            }
            out.print("</aggregation>\n");
            out.close();
            cacheFile.setLastModified(this.datasetManager.getLastScanned());
            this.cacheDirty = false;
            if (this.debug) {
                System.out.println("Aggregation persisted = " + cacheFile.getPath() + " lastModified= " + new Date(this.datasetManager.getLastScanned()));
            }
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    protected void persistRead() {
        Element aggElem;
        if (diskCache2 == null) {
            return;
        }
        String cacheName = this.getCacheName();
        if (cacheName == null) {
            return;
        }
        File cacheFile = diskCache2.getCacheFile(cacheName);
        if (!cacheFile.exists()) {
            return;
        }
        if (this.debugCache) {
            System.out.println(" Try to Read cache " + cacheFile.getPath());
        }
        try {
            aggElem = Parse.readRootElement("file:" + cacheFile.getPath());
        }
        catch (IOException e) {
            if (this.debugCache) {
                System.out.println(" No cache for " + cacheName + " - " + e.getMessage());
            }
            return;
        }
        HashMap<String, Aggregation.Dataset> map = new HashMap<String, Aggregation.Dataset>();
        for (Aggregation.Dataset ds : this.getDatasets()) {
            map.put(ds.getLocation(), ds);
        }
        List ncList = aggElem.getChildren("netcdf", NcMLReader.ncNS);
        for (Element netcdfElemNested : ncList) {
            String coordValue;
            String location = netcdfElemNested.getAttributeValue("location");
            AggregationOuterDimension.DatasetOuterDimension dod = (AggregationOuterDimension.DatasetOuterDimension)map.get(location);
            if (null == dod || dod.ncoord != 0) continue;
            if (this.debugPersistDetail) {
                System.out.println("  use cache for " + location);
            }
            String ncoordsS = netcdfElemNested.getAttributeValue("ncoords");
            try {
                dod.ncoord = Integer.parseInt(ncoordsS);
            }
            catch (NumberFormatException e) {
                logger.error("bad ncoord attribute on dataset=" + location);
            }
            if ((coordValue = netcdfElemNested.getAttributeValue("coordValue")) == null) continue;
            dod.coordValue = coordValue;
        }
    }

    private String getCacheName() {
        String cacheName = this.ncDataset.getLocation();
        if (cacheName == null) {
            cacheName = this.ncDataset.getCacheName();
        }
        return cacheName;
    }
}

