/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import ucar.units.Prefix;
import ucar.units.PrefixDB;
import ucar.units.PrefixExistsException;
import ucar.units.PrefixName;
import ucar.units.PrefixSymbol;

public class PrefixDBImpl
implements PrefixDB,
Serializable {
    private final SortedSet nameSet = new TreeSet();
    private final SortedSet symbolSet = new TreeSet();
    private final Map valueMap = new TreeMap();

    public void addName(String name, double value) throws PrefixExistsException {
        PrefixName prefix = new PrefixName(name, value);
        this.nameSet.add(prefix);
    }

    public void addSymbol(String symbol, double value) throws PrefixExistsException {
        PrefixSymbol prefix = new PrefixSymbol(symbol, value);
        this.symbolSet.add(prefix);
        this.valueMap.put(new Double(value), prefix);
    }

    public Prefix getPrefixByName(String string) {
        return PrefixDBImpl.getPrefix(string, this.nameSet);
    }

    public Prefix getPrefixBySymbol(String string) {
        return PrefixDBImpl.getPrefix(string, this.symbolSet);
    }

    public Prefix getPrefixByValue(double value) {
        return (Prefix)this.valueMap.get(new Double(value));
    }

    private static Prefix getPrefix(String string, Set set) {
        int stringLen = string.length();
        for (Prefix prefix : set) {
            int comp = prefix.compareTo(string);
            if (comp == 0) {
                return prefix;
            }
            if (comp <= 0) continue;
            break;
        }
        return null;
    }

    public String toString() {
        return "nameSet=" + this.nameSet + "symbolSet=" + this.symbolSet + "valueMap=" + this.valueMap;
    }

    public Iterator iterator() {
        return this.nameSet.iterator();
    }

    public static void main(String[] args) throws Exception {
        PrefixDBImpl db = new PrefixDBImpl();
        db.addName("mega", 1000000.0);
        System.out.println("mega=" + db.getPrefixByName("mega").getValue());
        db.addSymbol("m", 0.001);
        System.out.println("m=" + db.getPrefixBySymbol("m").getValue());
        System.out.println("1e-3=" + db.getPrefixByValue(0.001).getID());
    }
}

