/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImporterMetadata
extends HashMap<String, Object> {
    public ImporterMetadata(IFormatReader r, ImportProcess process, boolean usePrefix) {
        this.putAll(r.getGlobalMetadata());
        this.put("Location", process.getCurrentFile());
        ImporterOptions options = process.getOptions();
        int oldSeries = r.getSeries();
        int seriesCount = r.getSeriesCount();
        int digits = ImporterMetadata.digits(seriesCount);
        for (int i = 0; i < seriesCount; ++i) {
            if (!options.isSeriesOn(i)) continue;
            r.setSeries(i);
            String s = "";
            if (usePrefix) {
                s = process.getOMEMetadata().getImageName(i);
                if ((s == null || s.trim().length() == 0) && seriesCount > 1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Series ");
                    int zeroes = digits - ImporterMetadata.digits(i + 1);
                    for (int j = 0; j < zeroes; ++j) {
                        sb.append(0);
                    }
                    sb.append(i + 1);
                    sb.append(" ");
                    s = sb.toString();
                } else {
                    s = s + " ";
                }
            }
            Hashtable<String, Object> seriesMeta = r.getSeriesMetadata();
            MetadataTools.merge(seriesMeta, this, s);
            String pad = " ";
            this.put(" " + s + "SizeX", new Integer(r.getSizeX()));
            this.put(" " + s + "SizeY", new Integer(r.getSizeY()));
            this.put(" " + s + "SizeZ", new Integer(r.getSizeZ()));
            this.put(" " + s + "SizeT", new Integer(r.getSizeT()));
            this.put(" " + s + "SizeC", new Integer(r.getSizeC()));
            this.put(" " + s + "IsRGB", new Boolean(r.isRGB()));
            this.put(" " + s + "PixelType", FormatTools.getPixelTypeString(r.getPixelType()));
            this.put(" " + s + "LittleEndian", new Boolean(r.isLittleEndian()));
            this.put(" " + s + "DimensionOrder", r.getDimensionOrder());
            this.put(" " + s + "IsInterleaved", new Boolean(r.isInterleaved()));
            this.put(" " + s + "BitsPerPixel", new Integer(r.getBitsPerPixel()));
            String seriesName = process.getOMEMetadata().getImageName(i);
            this.put(" Series " + i + " Name", seriesName);
        }
        r.setSeries(oldSeries);
    }

    public String getMetadataString(String separator) {
        ArrayList keys = new ArrayList(this.keySet());
        Collections.sort(keys);
        StringBuffer sb = new StringBuffer();
        for (String key : keys) {
            sb.append(key);
            sb.append(separator);
            sb.append(this.get(key));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getMetadataString(" = ");
    }

    private static int digits(int value) {
        int digits = 0;
        while (value > 0) {
            value /= 10;
            ++digits;
        }
        return digits;
    }
}

