/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.EventObject;
import thredds.util.IO;
import thredds.util.ListenerManager;

public class SocketMessage {
    private static final boolean debug = false;
    private ServerSocket server;
    private boolean isAlreadyRunning = false;
    private Thread listen;
    private ListenerManager lm;

    public SocketMessage(int port, String message) {
        try {
            this.server = new ServerSocket(port, 1);
            this.listen = new ListenThread();
            this.listen.start();
            this.lm = new ListenerManager("thredds.util.SocketMessage$EventListener", "thredds.util.SocketMessage$Event", "setMessage");
        }
        catch (BindException e) {
            if (message != null) {
                this.sendMessage(port, message);
            }
            this.isAlreadyRunning = true;
        }
        catch (IOException e) {
            System.out.println("SocketMessage IOException= " + e);
            e.printStackTrace();
        }
    }

    public boolean isAlreadyRunning() {
        return this.isAlreadyRunning;
    }

    public void addEventListener(EventListener l) {
        this.lm.addListener(l);
    }

    public void removeEventListener(EventListener l) {
        this.lm.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(int port, String message) {
        Socket connection = null;
        try {
            connection = new Socket("localhost", port);
            IO.writeContents(message, connection.getOutputStream());
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static void main(String[] args) {
        new SocketMessage(4444, "no");
        new SocketMessage(4444, "testit");
    }

    public static interface EventListener {
        public void setMessage(Event var1);
    }

    public class Event
    extends EventObject {
        private String message;

        Event(String message) {
            super(SocketMessage.this);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private class ListenThread
    extends Thread {
        String message;

        private ListenThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Socket connection = null;
                try {
                    connection = SocketMessage.this.server.accept();
                }
                catch (IOException e) {
                    System.out.println("SocketMessage accept= " + e);
                    e.printStackTrace();
                    return;
                }
                try {
                    this.message = IO.readContents(connection.getInputStream());
                    System.out.println(" SocketMessage got message= " + this.message);
                    SocketMessage.this.lm.sendEvent(new Event(this.message));
                    continue;
                }
                catch (IOException e) {
                    System.out.println("SocketMessage IOException reading= " + e);
                    e.printStackTrace();
                    continue;
                }
                finally {
                    try {
                        if (connection == null) continue;
                        connection.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                break;
            }
        }
    }
}

