/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureMembers;

public class ArrayStructureBB
extends ArrayStructure {
    protected ByteBuffer bbuffer;
    protected int bb_offset = 0;

    public ArrayStructureBB(StructureMembers members, int[] shape) {
        super(members, shape);
        this.bbuffer = ByteBuffer.allocate(this.nelems * this.getStructureSize());
        this.bbuffer.order(ByteOrder.BIG_ENDIAN);
    }

    public ArrayStructureBB(StructureMembers members, int[] shape, ByteBuffer bbuffer, int offset) {
        super(members, shape);
        this.bbuffer = bbuffer;
        this.bb_offset = offset;
    }

    protected StructureData makeStructureData(ArrayStructure as, int index) {
        return new StructureDataA(as, index);
    }

    public Object getStorage() {
        return this.bbuffer.array();
    }

    public double getScalarDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be double");
        }
        int offset = this.calcOffset(recnum, m);
        return this.bbuffer.getDouble(offset);
    }

    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be double");
        }
        int offset = this.calcOffset(recnum, m);
        int count = m.getSize();
        double[] pa = new double[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.getDouble(offset + i * 8);
        }
        return pa;
    }

    public float getScalarFloat(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be float");
        }
        int offset = this.calcOffset(recnum, m);
        return this.bbuffer.getFloat(offset);
    }

    public float[] getJavaArrayFloat(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be float");
        }
        int offset = this.calcOffset(recnum, m);
        int count = m.getSize();
        float[] pa = new float[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.getFloat(offset + i * 4);
        }
        return pa;
    }

    public byte getScalarByte(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.BYTE) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be byte");
        }
        int offset = this.calcOffset(recnum, m);
        return this.bbuffer.get(offset);
    }

    public byte[] getJavaArrayByte(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.BYTE) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be byte");
        }
        int offset = this.calcOffset(recnum, m);
        int count = m.getSize();
        byte[] pa = new byte[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.get(offset + i);
        }
        return pa;
    }

    public short getScalarShort(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.SHORT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be short");
        }
        int offset = this.calcOffset(recnum, m);
        return this.bbuffer.getShort(offset);
    }

    public short[] getJavaArrayShort(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.SHORT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be short");
        }
        int offset = this.calcOffset(recnum, m);
        int count = m.getSize();
        short[] pa = new short[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.getShort(offset + i * 2);
        }
        return pa;
    }

    public int getScalarInt(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.INT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be int");
        }
        int offset = this.calcOffset(recnum, m);
        return this.bbuffer.getInt(offset);
    }

    public int[] getJavaArrayInt(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.INT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be int");
        }
        int offset = this.calcOffset(recnum, m);
        int count = m.getSize();
        int[] pa = new int[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.getInt(offset + i * 4);
        }
        return pa;
    }

    public long getScalarLong(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.LONG) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be long");
        }
        int offset = this.calcOffset(recnum, m);
        return this.bbuffer.getLong(offset);
    }

    public long[] getJavaArrayLong(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.LONG) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be long");
        }
        int offset = this.calcOffset(recnum, m);
        int count = m.getSize();
        long[] pa = new long[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.getLong(offset + i * 8);
        }
        return pa;
    }

    public char getScalarChar(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be char");
        }
        int offset = this.calcOffset(recnum, m);
        return (char)this.bbuffer.get(offset);
    }

    public char[] getJavaArrayChar(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be char");
        }
        int offset = this.calcOffset(recnum, m);
        int count = m.getSize();
        char[] pa = new char[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = (char)this.bbuffer.get(offset + i);
        }
        return pa;
    }

    public String getScalarString(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.CHAR || m.getDataType() == DataType.STRING) {
            int i;
            int offset = this.calcOffset(recnum, m);
            int count = m.getSize();
            byte[] pa = new byte[count];
            for (i = 0; i < count; ++i) {
                pa[i] = this.bbuffer.get(offset + i);
                if (0 == pa[i]) break;
            }
            return new String(pa, 0, i);
        }
        throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be String or char");
    }

    public String[] getJavaArrayString(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be char");
        }
        int[] shape = m.getShape();
        int rank = shape.length;
        if (rank < 2) {
            String[] result = new String[]{this.getScalarString(recnum, m)};
            return result;
        }
        int strlen = shape[rank - 1];
        int n = m.getSize() / strlen;
        int offset = this.calcOffset(recnum, m);
        String[] result = new String[n];
        for (int i = 0; i < n; ++i) {
            byte[] bytes = new byte[strlen];
            for (int j = 0; j < bytes.length; ++j) {
                bytes[j] = this.bbuffer.get(offset + i * strlen + j);
            }
            result[i] = new String(bytes);
        }
        return result;
    }

    public StructureData getScalarStructure(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.STRUCTURE) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be Structure");
        }
        int offset = this.calcOffset(recnum, m);
        ArrayStructureBB subset = new ArrayStructureBB(m.getStructureMembers(), new int[]{1}, this.bbuffer, offset);
        return new StructureDataA(subset, 0);
    }

    public ArrayStructure getArrayStructure(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.STRUCTURE) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be Structure");
        }
        int offset = this.calcOffset(recnum, m);
        return new ArrayStructureBB(m.getStructureMembers(), m.getShape(), this.bbuffer, offset);
    }

    public static void main(String[] argv) {
        byte[] ba = new byte[20];
        for (int i = 0; i < ba.length; ++i) {
            ba[i] = (byte)i;
        }
        ByteBuffer bbw = ByteBuffer.wrap(ba, 5, 15);
        bbw.get(0);
        System.out.println(" bbw(0)=" + bbw.get(0) + " i would expect = 5");
        bbw.position(5);
        System.out.println(" bbw(0)=" + bbw.get(0) + " i would expect = 4");
    }

    protected int calcOffset(int recnum, StructureMembers.Member m) {
        return this.bb_offset + recnum * this.getStructureSize() + m.getDataParam();
    }
}

