/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.util.Iterator;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;

public class ResultService
extends InvService {
    private String accessPointHeader = null;
    private boolean isValid = true;
    private StringBuffer log = new StringBuffer();

    public ResultService(String name, ServiceType serviceType, String base, String suffix, String accessPointHeader) {
        super(name, serviceType.toString(), base, suffix, null);
        this.accessPointHeader = accessPointHeader;
    }

    protected ResultService(ResultService service) {
        this(service, service.getAccessPointHeader());
    }

    public ResultService(InvService service, String accessPointHeader) {
        super(service.getName(), service.getServiceType().toString(), service.getBase(), service.getSuffix(), service.getDescription());
        for (InvProperty prop : service.getProperties()) {
            this.addProperty(new InvProperty(prop.getName(), prop.getValue()));
        }
        if (service.getServiceType() == ServiceType.COMPOUND) {
            Iterator<Object> it = service.getServices().iterator();
            while (it.hasNext()) {
                this.addService((InvService)it.next());
            }
        }
        this.accessPointHeader = accessPointHeader;
    }

    public String getAccessPointHeader() {
        return this.accessPointHeader;
    }

    public void setAccessPointHeader(String accessPointHeader) {
        this.accessPointHeader = accessPointHeader;
    }

    protected boolean validate(StringBuffer out) {
        this.isValid = true;
        if (this.log.length() > 0) {
            out.append(this.log);
        }
        if (this.getAccessPointHeader() == null) {
            this.isValid = false;
            out.append(" ** ResultService (1): a null 'accessPointHeader' is invalid.");
        }
        return this.isValid;
    }

    public String toString() {
        return "ResultService[" + super.toString() + " accessPointHeader:<" + this.getAccessPointHeader() + ">]";
    }
}

