/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import ome.xml.model.primitives.PositiveFloat;

public class MicromanagerReader
extends FormatReader {
    public static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static final String METADATA = "metadata.txt";
    private MinimalTiffReader tiffReader;
    private Vector<String> tiffs;
    private String metadataFile;
    private String[] channels;
    private String comment;
    private String time;
    private Double exposureTime;
    private Double sliceThickness;
    private Double pixelSize;
    private Double[] timestamps;
    private int gain;
    private String binning;
    private String detectorID;
    private String detectorModel;
    private String detectorManufacturer;
    private double temperature;
    private Vector<Double> voltage;
    private String cameraRef;
    private String cameraMode;

    public MicromanagerReader() {
        super("Micro-Manager", new String[]{"tif", "tiff", "txt"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        if (name.equals(METADATA) || name.endsWith(File.separator + METADATA)) {
            try {
                RandomAccessInputStream stream = new RandomAccessInputStream(name);
                long length = stream.length();
                stream.close();
                return length > 0L;
            }
            catch (IOException e) {
                return false;
            }
        }
        try {
            Location parent = new Location(name).getAbsoluteFile().getParentFile();
            Location metaFile = new Location(parent, METADATA);
            RandomAccessInputStream s = new RandomAccessInputStream(name);
            boolean validTIFF = this.isThisType(s);
            s.close();
            return metaFile.exists() && metaFile.length() > 0L && validTIFF;
        }
        catch (NullPointerException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (this.tiffReader == null) {
            this.tiffReader = new MinimalTiffReader();
        }
        return this.tiffReader.isThisType(stream);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        files.add(this.metadataFile);
        if (!noPixels) {
            files.addAll(this.tiffs);
        }
        return files.toArray(new String[files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (new Location(this.tiffs.get(no)).exists()) {
            this.tiffReader.setId(this.tiffs.get(no));
            return this.tiffReader.openBytes(0, buf, x, y, w, h);
        }
        LOGGER.warn("File for image #{} ({}) is missing.", no, (Object)this.tiffs.get(no));
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiffReader != null) {
            this.tiffReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.tiffReader = null;
            this.tiffs = null;
            this.time = null;
            this.comment = null;
            this.pixelSize = null;
            this.sliceThickness = null;
            this.exposureTime = null;
            this.timestamps = null;
            this.metadataFile = null;
            this.channels = null;
            this.gain = 0;
            this.detectorManufacturer = null;
            this.detectorModel = null;
            this.detectorID = null;
            this.binning = null;
            this.temperature = 0.0;
            this.voltage = null;
            this.cameraMode = null;
            this.cameraRef = null;
        }
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader.getOptimalTileWidth();
    }

    /*
     * Unable to fully structure code
     */
    public void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.tiffReader = new MinimalTiffReader();
        MicromanagerReader.LOGGER.info("Reading metadata file");
        file = new Location(this.currentId).getAbsoluteFile();
        parentFile = file.getParentFile();
        this.metadataFile = "metadata.txt";
        parent = "";
        if (file.exists()) {
            this.metadataFile = new Location(parentFile, "metadata.txt").getAbsolutePath();
            parent = parentFile.getAbsolutePath() + File.separator;
        }
        this.in = new RandomAccessInputStream(this.metadataFile);
        s = DataTools.readFile(this.metadataFile);
        MicromanagerReader.LOGGER.info("Finding image file names");
        baseTiff = null;
        this.tiffs = new Vector<E>();
        pos = 0;
        while ((pos = s.indexOf("FileName", pos)) != -1 && (long)pos < this.in.length()) {
            name = s.substring(s.indexOf(":", pos), s.indexOf(",", pos));
            baseTiff = parent + name.substring(3, name.length() - 1);
            ++pos;
        }
        MicromanagerReader.LOGGER.info("Populating metadata");
        stamps = new Vector<Double>();
        this.voltage = new Vector<E>();
        st = new StringTokenizer(s, "\n");
        slice = new int[3];
        while (st.hasMoreTokens()) {
            token = st.nextToken().trim();
            open = token.indexOf("[") != -1;
            v0 = closed = token.indexOf("]") != -1;
            if (open || !open && !closed && !token.equals("{") && !token.startsWith("}")) {
                quote = token.indexOf("\"") + 1;
                key = token.substring(quote, token.indexOf("\"", quote));
                value = null;
                if (open == closed) {
                    value = token.substring(token.indexOf(":") + 1);
                } else if (!closed) {
                    valueBuffer = new StringBuffer();
                    while (!closed) {
                        token = st.nextToken();
                        closed = token.indexOf("]") != -1;
                        valueBuffer.append(token);
                    }
                    value = valueBuffer.toString();
                    value = value.replaceAll("\n", "");
                }
                if (value == null) continue;
                startIndex = value.indexOf("[");
                endIndex = value.indexOf("]");
                if (endIndex == -1) {
                    endIndex = value.length();
                }
                value = value.substring(startIndex + 1, endIndex).trim();
                value = value.substring(0, value.length() - 1);
                if ((value = value.replaceAll("\"", "")).endsWith(",")) {
                    value = value.substring(0, value.length() - 1);
                }
                this.addGlobalMeta(key, value);
                if (key.equals("Channels")) {
                    this.core[0].sizeC = Integer.parseInt(value);
                } else if (key.equals("ChNames")) {
                    this.channels = value.split(",");
                    for (q = 0; q < this.channels.length; ++q) {
                        this.channels[q] = this.channels[q].replaceAll("\"", "").trim();
                    }
                } else if (key.equals("Frames")) {
                    this.core[0].sizeT = Integer.parseInt(value);
                } else if (key.equals("Slices")) {
                    this.core[0].sizeZ = Integer.parseInt(value);
                } else if (key.equals("PixelSize_um")) {
                    this.pixelSize = new Double(value);
                } else if (key.equals("z-step_um")) {
                    this.sliceThickness = new Double(value);
                } else if (key.equals("Time")) {
                    this.time = value;
                } else if (key.equals("Comment")) {
                    this.comment = value;
                }
            }
            if (!token.startsWith("\"FrameKey")) continue;
            dash = token.indexOf("-") + 1;
            nextDash = token.indexOf("-", dash);
            slice[2] = Integer.parseInt(token.substring(dash, nextDash));
            dash = nextDash + 1;
            nextDash = token.indexOf("-", dash);
            slice[1] = Integer.parseInt(token.substring(dash, nextDash));
            dash = nextDash + 1;
            slice[0] = Integer.parseInt(token.substring(dash, token.indexOf("\"", dash)));
            token = st.nextToken().trim();
            key = "";
            value = "";
            valueArray = false;
            while (!token.startsWith("}")) {
                if (!valueArray) ** GOTO lbl105
                if (token.trim().equals("],")) {
                    valueArray = false;
                } else {
                    value = value + token.trim().replaceAll("\"", "");
                    token = st.nextToken().trim();
                    continue;
lbl105:
                    // 1 sources

                    colon = token.indexOf(":");
                    key = token.substring(1, colon).trim();
                    value = token.substring(colon + 1, token.length() - 1).trim();
                    key = key.replaceAll("\"", "");
                    value = value.replaceAll("\"", "");
                    if (token.trim().endsWith("[")) {
                        valueArray = true;
                        token = st.nextToken().trim();
                        continue;
                    }
                }
                this.addGlobalMeta(key, value);
                if (key.equals("Exposure-ms")) {
                    t = Double.parseDouble(value);
                    this.exposureTime = new Double(t / 1000.0);
                } else if (key.equals("ElapsedTime-ms")) {
                    t = Double.parseDouble(value);
                    stamps.add(new Double(t / 1000.0));
                } else if (key.equals("Core-Camera")) {
                    this.cameraRef = value;
                } else if (key.equals(this.cameraRef + "-Binning")) {
                    this.binning = value.indexOf("x") != -1 ? value : value + "x" + value;
                } else if (key.equals(this.cameraRef + "-CameraID")) {
                    this.detectorID = value;
                } else if (key.equals(this.cameraRef + "-CameraName")) {
                    this.detectorModel = value;
                } else if (key.equals(this.cameraRef + "-Gain")) {
                    this.gain = (int)Double.parseDouble(value);
                } else if (key.equals(this.cameraRef + "-Name")) {
                    this.detectorManufacturer = value;
                } else if (key.equals(this.cameraRef + "-Temperature")) {
                    this.temperature = Double.parseDouble(value);
                } else if (key.equals(this.cameraRef + "-CCDMode")) {
                    this.cameraMode = value;
                } else if (key.startsWith("DAC-") && key.endsWith("-Volts")) {
                    this.voltage.add(new Double(value));
                }
                token = st.nextToken().trim();
            }
        }
        this.timestamps = stamps.toArray(new Double[stamps.size()]);
        Arrays.sort((Object[])this.timestamps);
        this.buildTIFFList(baseTiff);
        if (this.tiffs.size() == 0) {
            uniqueZ = new Vector<String>();
            uniqueC = new Vector<String>();
            uniqueT = new Vector<String>();
            dir = new Location(this.currentId).getAbsoluteFile().getParentFile();
            files = dir.list(true);
            Arrays.sort(files);
            for (Object f : files) {
                if (!MicromanagerReader.checkSuffix((String)f, "tif") && !MicromanagerReader.checkSuffix((String)f, "tiff")) continue;
                blocks = f.split("_");
                if (!uniqueT.contains(blocks[1])) {
                    uniqueT.add(blocks[1]);
                }
                if (!uniqueC.contains(blocks[2])) {
                    uniqueC.add(blocks[2]);
                }
                if (!uniqueZ.contains(blocks[3])) {
                    uniqueZ.add(blocks[3]);
                }
                this.tiffs.add(new Location(dir, (String)f).getAbsolutePath());
            }
            this.core[0].sizeZ = uniqueZ.size();
            this.core[0].sizeC = uniqueC.size();
            this.core[0].sizeT = uniqueT.size();
            if (this.tiffs.size() == 0) {
                throw new FormatException("Could not find TIFF files.");
            }
        }
        this.tiffReader.setId(this.tiffs.get(0));
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = this.tiffs.size() / this.getSizeC();
        }
        this.core[0].sizeX = this.tiffReader.getSizeX();
        this.core[0].sizeY = this.tiffReader.getSizeY();
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].pixelType = this.tiffReader.getPixelType();
        this.core[0].rgb = this.tiffReader.isRGB();
        this.core[0].interleaved = false;
        this.core[0].littleEndian = this.tiffReader.isLittleEndian();
        this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.time != null) {
            date = DateTools.formatDate(this.time, "EEE MMM dd HH:mm:ss zzz yyyy");
            store.setImageAcquiredDate(date, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(this.comment, 0);
            instrumentID = MetadataTools.createLSID("Instrument", new int[]{0});
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            for (i = 0; i < this.channels.length; ++i) {
                store.setChannelName(this.channels[i], 0, i);
            }
            if (this.pixelSize != null && this.pixelSize > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(this.pixelSize), 0);
                store.setPixelsPhysicalSizeY(new PositiveFloat(this.pixelSize), 0);
            }
            if (this.sliceThickness != null && this.sliceThickness > 0.0) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(this.sliceThickness), 0);
            }
            for (i = 0; i < this.getImageCount(); ++i) {
                store.setPlaneExposureTime(this.exposureTime, 0, i);
                if (i >= this.timestamps.length) continue;
                store.setPlaneDeltaT(this.timestamps[i], 0, i);
            }
            serialNumber = this.detectorID;
            this.detectorID = MetadataTools.createLSID("Detector", new int[]{0, 0});
            for (i = 0; i < this.channels.length; ++i) {
                store.setDetectorSettingsBinning(this.getBinning(this.binning), 0, i);
                store.setDetectorSettingsGain(new Double(this.gain), 0, i);
                if (i < this.voltage.size()) {
                    store.setDetectorSettingsVoltage(this.voltage.get(i), 0, i);
                }
                store.setDetectorSettingsID(this.detectorID, 0, i);
            }
            store.setDetectorID(this.detectorID, 0, 0);
            if (this.detectorModel != null) {
                store.setDetectorModel(this.detectorModel, 0, 0);
            }
            if (serialNumber != null) {
                store.setDetectorSerialNumber(serialNumber, 0, 0);
            }
            if (this.detectorManufacturer != null) {
                store.setDetectorManufacturer(this.detectorManufacturer, 0, 0);
            }
            if (this.cameraMode == null) {
                this.cameraMode = "Other";
            }
            store.setDetectorType(this.getDetectorType(this.cameraMode), 0, 0);
            store.setImagingEnvironmentTemperature(this.temperature, 0);
        }
    }

    private void buildTIFFList(String baseTiff) {
        LOGGER.info("Building list of TIFFs");
        String prefix = "";
        if (baseTiff.indexOf(File.separator) != -1) {
            prefix = baseTiff.substring(0, baseTiff.lastIndexOf(File.separator) + 1);
            baseTiff = baseTiff.substring(baseTiff.lastIndexOf(File.separator) + 1);
        }
        String[] blocks = baseTiff.split("_");
        StringBuffer filename = new StringBuffer();
        for (int t = 0; t < this.getSizeT(); ++t) {
            for (int c = 0; c < this.getSizeC(); ++c) {
                for (int z = 0; z < this.getSizeZ(); ++z) {
                    int q;
                    filename.append(prefix);
                    filename.append(blocks[0]);
                    filename.append("_");
                    int zeros = blocks[1].length() - String.valueOf(t).length();
                    for (q = 0; q < zeros; ++q) {
                        filename.append("0");
                    }
                    filename.append(t);
                    filename.append("_");
                    filename.append(this.channels[c]);
                    filename.append("_");
                    zeros = blocks[3].length() - String.valueOf(z).length() - 4;
                    for (q = 0; q < zeros; ++q) {
                        filename.append("0");
                    }
                    filename.append(z);
                    filename.append(".tif");
                    this.tiffs.add(filename.toString());
                    filename.delete(0, filename.length());
                }
            }
        }
    }
}

