/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.IOException;
import java.util.Random;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.OMETiffWriter;
import loci.formats.services.OMEXMLService;
import loci.formats.tiff.IFD;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;

public class Make2ChannelImage {
    public static void main(String[] args) {
        OMETiffWriter writer = new OMETiffWriter();
        String filename = "c:\\Temp\\m2ci.tif";
        if (args.length > 0) {
            filename = args[0];
        }
        Random r = new Random(932985L);
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLMetadata meta = factory.getInstance(OMEXMLService.class).createOMEXMLMetadata();
            meta.setPixelsDimensionOrder(DimensionOrder.XYCZT, 0);
            meta.setPixelsType(PixelType.UINT16, 0);
            meta.setPixelsSizeX(new PositiveInteger(512), 0);
            meta.setPixelsSizeY(new PositiveInteger(512), 0);
            meta.setPixelsSizeC(new PositiveInteger(2), 0);
            meta.setPixelsSizeT(new PositiveInteger(1), 0);
            meta.setPixelsSizeZ(new PositiveInteger(1), 0);
            meta.setChannelSamplesPerPixel(new PositiveInteger(1), 0, 0);
            meta.setChannelSamplesPerPixel(new PositiveInteger(1), 0, 1);
            meta.setImageID("Make2ChannelImage", 0);
            meta.setPixelsID("Make2ChannelImage", 0);
            meta.setChannelID("FITC", 0, 0);
            meta.setChannelID("DAPI", 0, 1);
            meta.setPixelsBinDataBigEndian(false, 0, 0);
            meta.setPixelsBinDataBigEndian(false, 0, 1);
            writer.setMetadataRetrieve(meta);
            writer.setId(filename);
            for (int i = 0; i < 2; ++i) {
                IFD ifd = new IFD();
                ifd.putIFDValue(280, 0);
                ifd.putIFDValue(281, 4095);
                byte[] buffer = new byte[524288];
                r.nextBytes(buffer);
                for (int j = 1; j < buffer.length; j += 2) {
                    int n = j;
                    buffer[n] = (byte)(buffer[n] & 0x3F);
                }
                writer.saveBytes(i, buffer, ifd);
            }
            writer.close();
        }
        catch (DependencyException e) {
            e.printStackTrace();
            return;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return;
        }
        catch (FormatException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

