/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.ddf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import loci.poi.ddf.EscherRecord;
import loci.poi.ddf.EscherRecordFactory;
import loci.poi.ddf.EscherSerializationListener;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.util.HexDump;
import loci.poi.util.LittleEndian;

public class EscherDggRecord
extends EscherRecord {
    public static final short RECORD_ID = -4090;
    public static final String RECORD_DESCRIPTION = "MsofbtDgg";
    private int field_1_shapeIdMax;
    private int field_3_numShapesSaved;
    private int field_4_drawingsSaved;
    private FileIdCluster[] field_5_fileIdClusters;

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        int pos = offset + 8;
        int size = 0;
        this.field_1_shapeIdMax = LittleEndian.getInt(data, pos + size);
        int field_2_numIdClusters = LittleEndian.getInt(data, pos + (size += 4));
        this.field_3_numShapesSaved = LittleEndian.getInt(data, pos + (size += 4));
        this.field_4_drawingsSaved = LittleEndian.getInt(data, pos + (size += 4));
        this.field_5_fileIdClusters = new FileIdCluster[(bytesRemaining - (size += 4)) / 8];
        for (int i = 0; i < this.field_5_fileIdClusters.length; ++i) {
            this.field_5_fileIdClusters[i] = new FileIdCluster(LittleEndian.getInt(data, pos + size), LittleEndian.getInt(data, pos + size + 4));
            size += 8;
        }
        if ((bytesRemaining -= size) != 0) {
            throw new RecordFormatException("Expecting no remaining data but got " + bytesRemaining + " byte(s).");
        }
        return 8 + size + bytesRemaining;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        int pos = offset;
        LittleEndian.putShort(data, pos, this.getOptions());
        LittleEndian.putShort(data, pos += 2, this.getRecordId());
        int remainingBytes = this.getRecordSize() - 8;
        LittleEndian.putInt(data, pos += 2, remainingBytes);
        LittleEndian.putInt(data, pos += 4, this.field_1_shapeIdMax);
        LittleEndian.putInt(data, pos += 4, this.getNumIdClusters());
        LittleEndian.putInt(data, pos += 4, this.field_3_numShapesSaved);
        LittleEndian.putInt(data, pos += 4, this.field_4_drawingsSaved);
        pos += 4;
        for (int i = 0; i < this.field_5_fileIdClusters.length; ++i) {
            LittleEndian.putInt(data, pos, this.field_5_fileIdClusters[i].field_1_drawingGroupId);
            LittleEndian.putInt(data, pos += 4, this.field_5_fileIdClusters[i].field_2_numShapeIdsUsed);
            pos += 4;
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), this.getRecordSize(), this);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 24 + 8 * this.field_5_fileIdClusters.length;
    }

    public short getRecordId() {
        return -4090;
    }

    public String getRecordName() {
        return "Dgg";
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer field_5_string = new StringBuffer();
        for (int i = 0; i < this.field_5_fileIdClusters.length; ++i) {
            field_5_string.append("  DrawingGroupId").append(i + 1).append(": ");
            field_5_string.append(this.field_5_fileIdClusters[i].field_1_drawingGroupId);
            field_5_string.append(nl);
            field_5_string.append("  NumShapeIdsUsed").append(i + 1).append(": ");
            field_5_string.append(this.field_5_fileIdClusters[i].field_2_numShapeIdsUsed);
            field_5_string.append(nl);
        }
        return this.getClass().getName() + ":" + nl + "  RecordId: 0x" + HexDump.toHex((short)-4090) + nl + "  Options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  ShapeIdMax: " + this.field_1_shapeIdMax + nl + "  NumIdClusters: " + this.getNumIdClusters() + nl + "  NumShapesSaved: " + this.field_3_numShapesSaved + nl + "  DrawingsSaved: " + this.field_4_drawingsSaved + nl + "" + field_5_string.toString();
    }

    public int getShapeIdMax() {
        return this.field_1_shapeIdMax;
    }

    public void setShapeIdMax(int field_1_shapeIdMax) {
        this.field_1_shapeIdMax = field_1_shapeIdMax;
    }

    public int getNumIdClusters() {
        return this.field_5_fileIdClusters.length + 1;
    }

    public int getNumShapesSaved() {
        return this.field_3_numShapesSaved;
    }

    public void setNumShapesSaved(int field_3_numShapesSaved) {
        this.field_3_numShapesSaved = field_3_numShapesSaved;
    }

    public int getDrawingsSaved() {
        return this.field_4_drawingsSaved;
    }

    public void setDrawingsSaved(int field_4_drawingsSaved) {
        this.field_4_drawingsSaved = field_4_drawingsSaved;
    }

    public FileIdCluster[] getFileIdClusters() {
        return this.field_5_fileIdClusters;
    }

    public void setFileIdClusters(FileIdCluster[] field_5_fileIdClusters) {
        this.field_5_fileIdClusters = field_5_fileIdClusters;
    }

    public void addCluster(int dgId, int numShapedUsed) {
        ArrayList<FileIdCluster> clusters = new ArrayList<FileIdCluster>(Arrays.asList(this.field_5_fileIdClusters));
        clusters.add(new FileIdCluster(dgId, numShapedUsed));
        Collections.sort(clusters, new Comparator(){

            public int compare(Object o1, Object o2) {
                FileIdCluster f1 = (FileIdCluster)o1;
                FileIdCluster f2 = (FileIdCluster)o2;
                if (f1.getDrawingGroupId() == f2.getDrawingGroupId()) {
                    return 0;
                }
                if (f1.getDrawingGroupId() < f2.getDrawingGroupId()) {
                    return -1;
                }
                return 1;
            }
        });
        this.field_5_fileIdClusters = clusters.toArray(new FileIdCluster[clusters.size()]);
    }

    public static class FileIdCluster {
        private int field_1_drawingGroupId;
        private int field_2_numShapeIdsUsed;

        public FileIdCluster(int drawingGroupId, int numShapeIdsUsed) {
            this.field_1_drawingGroupId = drawingGroupId;
            this.field_2_numShapeIdsUsed = numShapeIdsUsed;
        }

        public int getDrawingGroupId() {
            return this.field_1_drawingGroupId;
        }

        public int getNumShapeIdsUsed() {
            return this.field_2_numShapeIdsUsed;
        }

        public void incrementShapeId() {
            ++this.field_2_numShapeIdsUsed;
        }
    }
}

