/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.storage;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import loci.poi.poifs.storage.BlockWritable;
import loci.poi.poifs.storage.ListManagedBlock;

public class SmallDocumentBlock
implements BlockWritable,
ListManagedBlock {
    private byte[] _data;
    private static final byte _default_fill = -1;
    private static final int _block_size = 64;
    private int _blocks_per_big_block;

    private SmallDocumentBlock(byte[] data, int index, int size) {
        this(size);
        System.arraycopy(data, index * 64, this._data, 0, 64);
    }

    private SmallDocumentBlock(int size) {
        this._blocks_per_big_block = size / 64;
        this._data = new byte[64];
    }

    public int getBigBlockSize() {
        return this._blocks_per_big_block * 64;
    }

    public static SmallDocumentBlock[] convert(byte[] array, int size) {
        SmallDocumentBlock[] rval = new SmallDocumentBlock[(size + 64 - 1) / 64];
        int offset = 0;
        for (int k = 0; k < rval.length; ++k) {
            rval[k] = new SmallDocumentBlock(size);
            if (offset < array.length) {
                int length = Math.min(64, array.length - offset);
                System.arraycopy(array, offset, rval[k]._data, 0, length);
                if (length != 64) {
                    Arrays.fill(rval[k]._data, length, 64, (byte)-1);
                }
            } else {
                Arrays.fill(rval[k]._data, (byte)-1);
            }
            offset += 64;
        }
        return rval;
    }

    public static int fill(List blocks, int size) {
        int count;
        int big_block_count = (count + size / 64 - 1) / (size / 64);
        int full_count = big_block_count * (size / 64);
        for (count = blocks.size(); count < full_count; ++count) {
            blocks.add(SmallDocumentBlock.makeEmptySmallDocumentBlock(size / 64 * 64));
        }
        return big_block_count;
    }

    public static SmallDocumentBlock[] convert(BlockWritable[] store, int size) throws IOException, ArrayIndexOutOfBoundsException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (int j = 0; j < store.length; ++j) {
            store[j].writeBlocks(stream);
        }
        byte[] data = stream.toByteArray();
        SmallDocumentBlock[] rval = new SmallDocumentBlock[SmallDocumentBlock.convertToBlockCount(size)];
        for (int index = 0; index < rval.length; ++index) {
            rval[index] = new SmallDocumentBlock(data, index, size);
        }
        return rval;
    }

    public static List extract(ListManagedBlock[] blocks, int size) throws IOException {
        ArrayList<SmallDocumentBlock> sdbs = new ArrayList<SmallDocumentBlock>();
        for (int j = 0; j < blocks.length; ++j) {
            byte[] data = blocks[j].getData();
            for (int k = 0; k < size / 64; ++k) {
                sdbs.add(new SmallDocumentBlock(data, k, size));
            }
        }
        return sdbs;
    }

    public static void read(BlockWritable[] blocks, byte[] buffer, int offset) {
        int firstBlockIndex = offset / 64;
        int firstBlockOffset = offset % 64;
        int lastBlockIndex = (offset + buffer.length - 1) / 64;
        if (firstBlockIndex == lastBlockIndex) {
            System.arraycopy(((SmallDocumentBlock)blocks[firstBlockIndex])._data, firstBlockOffset, buffer, 0, buffer.length);
        } else {
            int buffer_offset = 0;
            System.arraycopy(((SmallDocumentBlock)blocks[firstBlockIndex])._data, firstBlockOffset, buffer, buffer_offset, 64 - firstBlockOffset);
            buffer_offset += 64 - firstBlockOffset;
            for (int j = firstBlockIndex + 1; j < lastBlockIndex; ++j) {
                System.arraycopy(((SmallDocumentBlock)blocks[j])._data, 0, buffer, buffer_offset, 64);
                buffer_offset += 64;
            }
            System.arraycopy(((SmallDocumentBlock)blocks[lastBlockIndex])._data, 0, buffer, buffer_offset, buffer.length - buffer_offset);
        }
    }

    public static int calcSize(int size) {
        return size * 64;
    }

    private static SmallDocumentBlock makeEmptySmallDocumentBlock(int size) {
        SmallDocumentBlock block = new SmallDocumentBlock(size);
        Arrays.fill(block._data, (byte)-1);
        return block;
    }

    private static int convertToBlockCount(int size) {
        return (size + 64 - 1) / 64;
    }

    public void writeBlocks(OutputStream stream) throws IOException {
        stream.write(this._data);
    }

    public byte[] getData() throws IOException {
        return this._data;
    }
}

