/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PixelType implements Enumeration
{
    INT8("int8"),
    INT16("int16"),
    INT32("int32"),
    UINT8("uint8"),
    UINT16("uint16"),
    UINT32("uint32"),
    FLOAT("float"),
    BIT("bit"),
    DOUBLE("double"),
    COMPLEX("complex"),
    DOUBLECOMPLEX("double-complex");

    private final String value;

    private PixelType(String value) {
        this.value = value;
    }

    public static PixelType fromString(String value) throws EnumerationException {
        if ("int8".equals(value)) {
            return INT8;
        }
        if ("int16".equals(value)) {
            return INT16;
        }
        if ("int32".equals(value)) {
            return INT32;
        }
        if ("uint8".equals(value)) {
            return UINT8;
        }
        if ("uint16".equals(value)) {
            return UINT16;
        }
        if ("uint32".equals(value)) {
            return UINT32;
        }
        if ("float".equals(value)) {
            return FLOAT;
        }
        if ("bit".equals(value)) {
            return BIT;
        }
        if ("double".equals(value)) {
            return DOUBLE;
        }
        if ("complex".equals(value)) {
            return COMPLEX;
        }
        if ("double-complex".equals(value)) {
            return DOUBLECOMPLEX;
        }
        String s = String.format("%s not a supported value of %s", value, PixelType.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

