/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaserTypeEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LaserTypeEnumHandler.class);
    private static final Hashtable<String, String> patterns = LaserTypeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*Excimer\\s*", "Excimer");
        p.put("^\\s*Gas\\s*", "Gas");
        p.put("^\\s*MetalVapor\\s*", "MetalVapor");
        p.put("^\\s*SolidState\\s*", "SolidState");
        p.put("^\\s*Dye\\s*", "Dye");
        p.put("^\\s*Semiconductor\\s*", "Semiconductor");
        p.put("^\\s*FreeElectron\\s*", "FreeElectron");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return LaserType.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"LaserType", (Object)value);
        return LaserType.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return LaserType.class;
    }
}

