/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.cinrad;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.IndexIterator;
import ucar.ma2.Range;
import ucar.unidata.io.RandomAccessFile;

public class Cinrad2Record {
    public static final int REFLECTIVITY = 1;
    public static final int VELOCITY_HI = 2;
    public static final int VELOCITY_LOW = 4;
    public static final int SPECTRUM_WIDTH = 3;
    public static final int DOPPLER_RESOLUTION_LOW_CODE = 4;
    public static final int DOPPLER_RESOLUTION_HIGH_CODE = 2;
    public static final float HORIZONTAL_BEAM_WIDTH = 1.5f;
    public static final byte MISSING_DATA = 1;
    public static final byte BELOW_THRESHOLD = 0;
    static final int FILE_HEADER_SIZE = 0;
    private static final int CTM_HEADER_SIZE = 14;
    private static final int MESSAGE_HEADER_SIZE = 28;
    private static final int RADAR_DATA_SIZE = 2432;
    private static Logger logger = LoggerFactory.getLogger(Cinrad2Record.class);
    int recno;
    long message_offset;
    boolean hasReflectData;
    boolean hasDopplerData;
    short message_size = 0;
    byte id_channel = 0;
    public byte message_type = 0;
    short id_sequence = 0;
    short mess_julian_date = 0;
    int mess_msecs = 0;
    short seg_count = 0;
    short seg_number = 0;
    int data_msecs = 0;
    short data_julian_date = 0;
    short unamb_range = 0;
    int azimuth_ang = 0;
    short radial_num = 0;
    short radial_status = 0;
    short elevation_ang = 0;
    short elevation_num = 0;
    short reflect_first_gate = 0;
    short reflect_gate_size = 0;
    short reflect_gate_count = 0;
    short doppler_first_gate = 0;
    short doppler_gate_size = 0;
    short doppler_gate_count = 0;
    short cut = 0;
    float calibration = 0.0f;
    short resolution = 0;
    short vcp = 0;
    short nyquist_vel;
    short attenuation;
    short threshhold;
    private short reflect_offset;
    private short velocity_offset;
    private short spectWidth_offset;

    public static String getDatatypeName(int datatype) {
        switch (datatype) {
            case 1: {
                return "Reflectivity";
            }
            case 2: 
            case 4: {
                return "RadialVelocity";
            }
            case 3: {
                return "SpectrumWidth";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String getDatatypeUnits(int datatype) {
        switch (datatype) {
            case 1: {
                return "dBZ";
            }
            case 2: 
            case 3: 
            case 4: {
                return "m/s";
            }
        }
        throw new IllegalArgumentException();
    }

    public static float getDatatypeScaleFactor(int datatype) {
        switch (datatype) {
            case 1: {
                return 0.5f;
            }
            case 4: {
                return 1.0f;
            }
            case 2: 
            case 3: {
                return 0.5f;
            }
        }
        throw new IllegalArgumentException();
    }

    public static float getDatatypeAddOffset(int datatype) {
        switch (datatype) {
            case 1: {
                return -33.0f;
            }
            case 4: {
                return -129.0f;
            }
            case 2: 
            case 3: {
                return -64.5f;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String getMessageTypeName(int code) {
        switch (code) {
            case 1: {
                return "digital radar data";
            }
            case 2: {
                return "RDA status data";
            }
            case 3: {
                return "performance/maintainence data";
            }
            case 4: {
                return "console message - RDA to RPG";
            }
            case 5: {
                return "maintainence log data";
            }
            case 6: {
                return "RDA control ocmmands";
            }
            case 7: {
                return "volume coverage pattern";
            }
            case 8: {
                return "clutter censor zones";
            }
            case 9: {
                return "request for data";
            }
            case 10: {
                return "console message - RPG to RDA";
            }
            case 11: {
                return "loop back test - RDA to RPG";
            }
            case 12: {
                return "loop back test - RPG to RDA";
            }
            case 13: {
                return "clutter filter bypass map - RDA to RPG";
            }
            case 14: {
                return "edited clutter filter bypass map - RDA to RPG";
            }
            case 15: {
                return "Notchwidth Map";
            }
            case 18: {
                return "RDA Adaptation data";
            }
        }
        return "unknown " + code;
    }

    public static String getRadialStatusName(int code) {
        switch (code) {
            case 0: {
                return "start of new elevation";
            }
            case 1: {
                return "intermediate radial";
            }
            case 2: {
                return "end of elevation";
            }
            case 3: {
                return "begin volume scan";
            }
            case 4: {
                return "end volume scan";
            }
        }
        return "unknown " + code;
    }

    public static String getVolumeCoveragePatternName(int code) {
        switch (code) {
            case 11: {
                return "16 elevation scans every 5 mins";
            }
            case 12: {
                return "14 elevation scan every 4.1 mins";
            }
            case 21: {
                return "11 elevation scans every 6 mins";
            }
            case 31: {
                return "8 elevation scans every 10 mins";
            }
            case 32: {
                return "7 elevation scans every 10 mins";
            }
            case 121: {
                return "9 elevations, 20 scans every 5 minutes";
            }
        }
        return "unknown " + code;
    }

    public static Date getDate(int julianDays, int msecs) {
        long total = (long)(julianDays - 1) * 24L * 3600L * 1000L + (long)msecs;
        return new Date(total);
    }

    public static Cinrad2Record factory(RandomAccessFile din, int record) throws IOException {
        long offset = record * 2432 + 0;
        if (offset >= din.length()) {
            return null;
        }
        return new Cinrad2Record(din, record);
    }

    int getUInt(byte[] b, int num) {
        int i;
        int base = 1;
        int word = 0;
        int[] bv = new int[num];
        for (i = 0; i < num; ++i) {
            bv[i] = this.convertunsignedByte2Short(b[i]);
        }
        for (i = num - 1; i >= 0; --i) {
            word += base * b[i];
            base *= 256;
        }
        return word;
    }

    public short convertunsignedByte2Short(byte b) {
        return b < 0 ? (short)((short)b + 256) : (short)b;
    }

    public Cinrad2Record(RandomAccessFile din, int record) throws IOException {
        this.recno = record;
        this.message_offset = record * 2432 + 0;
        din.seek(this.message_offset);
        din.skipBytes(14);
        this.message_type = din.readByte();
        din.skipBytes(13);
        if (this.message_type != 1) {
            return;
        }
        this.data_msecs = din.readInt();
        this.data_julian_date = din.readShort();
        Date dd = this.getDate();
        this.unamb_range = din.readShort();
        this.azimuth_ang = din.readUnsignedShort();
        this.radial_num = din.readShort();
        this.radial_status = din.readShort();
        this.elevation_ang = din.readShort();
        this.elevation_num = din.readShort();
        this.reflect_first_gate = din.readShort();
        this.doppler_first_gate = din.readShort();
        this.reflect_gate_size = din.readShort();
        this.doppler_gate_size = din.readShort();
        this.reflect_gate_count = din.readShort();
        this.doppler_gate_count = din.readShort();
        din.skipBytes(6);
        this.reflect_offset = din.readShort();
        this.velocity_offset = din.readShort();
        this.spectWidth_offset = din.readShort();
        this.resolution = din.readShort();
        this.vcp = din.readShort();
        din.skipBytes(14);
        this.nyquist_vel = din.readShort();
        din.skipBytes(38);
        this.hasReflectData = this.reflect_gate_count > 0;
        this.hasDopplerData = this.doppler_gate_count > 0;
    }

    public void dumpMessage(PrintStream out, Date d) {
        out.println(this.recno + " ---------------------");
        out.println(" message type = " + Cinrad2Record.getMessageTypeName(this.message_type) + " (" + this.message_type + ")");
        out.println(" message size = " + this.message_size + " segment=" + this.seg_number + "/" + this.seg_count);
        out.println(" message date = " + d.toString());
        out.println(" channel id = " + this.id_channel);
    }

    public void dump(PrintStream out) {
        out.println(this.recno + " ------------------------------------------" + this.message_offset);
        out.println(" message type = " + Cinrad2Record.getMessageTypeName(this.message_type));
        out.println(" data date = " + this.getDate().toString());
        out.println(" elevation = " + this.getElevation() + " (" + this.elevation_num + ")");
        out.println(" azimuth = " + this.getAzimuth());
        out.println(" radial = " + this.radial_num + " status= " + Cinrad2Record.getRadialStatusName(this.radial_status) + " ratio = " + this.getAzimuth() / (float)this.radial_num);
        out.println(" reflectivity first= " + this.reflect_first_gate + " size= " + this.reflect_gate_size + " count= " + this.reflect_gate_count);
        out.println(" doppler first= " + this.doppler_first_gate + " size= " + this.doppler_gate_size + " count= " + this.doppler_gate_count);
        out.println(" offset: reflect= " + this.reflect_offset + " velocity= " + this.velocity_offset + " spWidth= " + this.spectWidth_offset);
        out.println(" pattern = " + this.vcp);
    }

    public void dump2(PrintStream out) {
        out.println(this.recno + "= " + this.elevation_num + " size = " + this.message_size);
    }

    public boolean checkOk() {
        boolean ok = true;
        if (this.message_type != 1) {
            return ok;
        }
        if (this.reflect_offset < 0 || this.reflect_offset > 2432) {
            logger.warn("****" + this.recno + " HAS bad reflect offset= " + this.reflect_offset + this.who());
            ok = false;
        }
        if (this.velocity_offset < 0 || this.velocity_offset > 2432) {
            logger.warn("****" + this.recno + " HAS bad velocity offset= " + this.velocity_offset + this.who());
            ok = false;
        }
        if (this.spectWidth_offset < 0 || this.spectWidth_offset > 2432) {
            logger.warn("****" + this.recno + " HAS bad spwidth offset= " + this.reflect_offset + this.who());
            ok = false;
        }
        if (this.velocity_offset > 0 && this.spectWidth_offset <= 0) {
            logger.warn("****" + this.recno + " HAS velocity NOT spectWidth!!" + this.who());
            ok = false;
        }
        if (this.velocity_offset <= 0 && this.spectWidth_offset > 0) {
            logger.warn("****" + this.recno + " HAS spectWidth AND NOT velocity!!" + this.who());
            ok = false;
        }
        if (!this.hasReflectData && !this.hasDopplerData) {
            logger.info("*** no reflect or dopplar = " + this.who());
        }
        return ok;
    }

    private String who() {
        return " message(" + this.recno + " " + this.message_offset + ")";
    }

    public float getAzimuth() {
        if (this.message_type != 1) {
            return -1.0f;
        }
        return 180.0f * (float)this.azimuth_ang / 32768.0f;
    }

    public float getElevation() {
        if (this.message_type != 1) {
            return -1.0f;
        }
        return 180.0f * (float)this.elevation_ang / 32768.0f;
    }

    public int getGateSize(int datatype) {
        switch (datatype) {
            case 1: {
                return this.reflect_gate_size;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.doppler_gate_size;
            }
        }
        return -1;
    }

    public int getGateStart(int datatype) {
        switch (datatype) {
            case 1: {
                return this.reflect_first_gate;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.doppler_first_gate;
            }
        }
        return -1;
    }

    public int getGateCount(int datatype) {
        switch (datatype) {
            case 1: {
                return this.reflect_gate_count;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.doppler_gate_count;
            }
        }
        return 0;
    }

    private short getDataOffset(int datatype) {
        switch (datatype) {
            case 1: {
                return this.reflect_offset;
            }
            case 2: 
            case 4: {
                return this.velocity_offset;
            }
            case 3: {
                return this.spectWidth_offset;
            }
        }
        return Short.MIN_VALUE;
    }

    public Date getDate() {
        return Cinrad2Record.getDate(this.data_julian_date, this.data_msecs);
    }

    public void readData(RandomAccessFile raf, int datatype, Range gateRange, IndexIterator ii) throws IOException {
        long offset = this.message_offset;
        offset += 28L;
        raf.seek(offset += (long)this.getDataOffset(datatype));
        if (logger.isDebugEnabled()) {
            logger.debug("  read recno " + this.recno + " at offset " + offset + " count= " + this.getGateCount(datatype));
            logger.debug("   offset: reflect= " + this.reflect_offset + " velocity= " + this.velocity_offset + " spWidth= " + this.spectWidth_offset);
        }
        int dataCount = this.getGateCount(datatype);
        byte[] data = new byte[dataCount];
        raf.readFully(data);
        for (int i = gateRange.first(); i <= gateRange.last(); i += gateRange.stride()) {
            if (i >= dataCount) {
                ii.setByteNext((byte)1);
                continue;
            }
            ii.setByteNext(data[i]);
        }
    }

    public String toString() {
        return "elev= " + this.elevation_num + " radial_num = " + this.radial_num;
    }
}

