"""
Function module that directly maps to the Box API
"""
import json

BOX_API_URL    = 'https://api.box.com/2.0'
BOX_UPLOAD_URL = 'https://upload.box.com/api/2.0'
def get_file_by_id(session, file_id):
    return session.authorized_request(BOX_API_URL + '/files/' + file_id)

def download_file_by_id(session, file_id):
    return session.authorized_request(BOX_API_URL + '/files/' + file_id + '/content')

def upload_file_into_folder_by_id(session, fp, filename, folder_id,
                                  content_created_at=None, content_modified_at=None):
    params = {
        'filename'            : filename,
        'folder_id'           : folder_id,
        # 'content_created_at'  : content_created_at,
        # 'content_modified_at' : content_modified_at,
    }
    file_data = fp.read()
    return session.authorized_request(BOX_UPLOAD_URL + '/files/content',
                                      files={ filename : (filename, file_data) },
                                      data=params,
                                      method='POST')

def delete_file_by_id(session, file_id, if_match_etag=None):
    headers = { 'If-Match' : if_match_etag } if if_match_etag else {}

    return session.authorized_request(BOX_API_URL + '/files/' + file_id,
                                      headers=headers,
                                      method='DELETE')



def get_folder_by_id(session, folder_id):
    return session.authorized_request(BOX_API_URL + '/folders/' + folder_id)

def get_items_for_folder_id(session, folder_id, limit=1000, offset=0, fields=''):
    data = json.dumps({
        'limit' : limit,
        'offset' : offset,
        'fields' : fields,
    })

    return session.authorized_request(
            BOX_API_URL + '/folders/' + folder_id + '/items',
            data=data
            )

def create_folder_in_folder_by_id(session, folder_name, parent_id):
    data = json.dumps({
        'name' : folder_name,
        'parent' : { 'id' : parent_id },
    })
    return session.authorized_request(
            BOX_API_URL + '/folders',
            data=data,
            method='POST'
            )

def delete_folder_by_id(session, folder_id, recursive=False, if_match_etag=None):
    headers = { 'If-Match' : if_match_etag } if if_match_etag else {}
    params = { 'recursive' : 'true' } if recursive else {}

    return session.authorized_request(BOX_API_URL + '/folders/' + folder_id,
                                      headers=headers,
                                      params=params,
                                      method='DELETE')

