from functools import partial

from pybox import api
from pybox.item import Item
from pybox.utils import file_or_path

class File(Item):

    def reload(self):
        return api.get_file_by_id(self.session, self.id)

    def download(self, f_or_path):
        with file_or_path(f_or_path, mode='w') as fp:
            response = api.download_file_by_id(self.session, self.id)
            for block in iter(partial(response.read, 1024), ''):
                fp.write(block)

    def delete(self):
        return api.delete_file_by_id(self.session, self.id, if_match_etag=self.etag)

