from pybox.metaclient import *

class Item(APIObject):
    id          = Field('id')
    name        = Field('name')
    etag        = Field('etag')
    description = LazyField('description')
    modified_at = LazyField('modified_at')

    def __init__(self, session, raw_object):
        self.session = session
        super(Item, self).__init__(raw_object)

    def reload(self):
        raise Exception('Item.reload_metadata is abstract and therefore not implemented.')

