import unittest
import urlparse

from pybox.session import Session

class TestSession(unittest.TestCase):

    def test_authorize_url(self):
        s = Session('abc', '123')
        url = s.authorize_url('foo').split('?')[1]
        data = urlparse.parse_qs(url)
        self.assertEquals(data['redirect_uri']  , ['foo'])
        self.assertEquals(data['client_id']     , ['abc'])
        self.assertEquals(data['response_type'] , ['code'])

    def test_authorize_url_with_state(self):
        s = Session('abc', '123')
        url = s.authorize_url('foo', state='baz').split('?')[1]
        data = urlparse.parse_qs(url)
        self.assertEquals(data['redirect_uri']  , ['foo'])
        self.assertEquals(data['client_id']     , ['abc'])
        self.assertEquals(data['response_type'] , ['code'])
        self.assertEquals(data['state']         , ['baz'])

    def test_authorized_request_only_to_box_urls(self):
        s = Session('abc', '123')
        with self.assertRaises(AssertionError):
            s.authorized_request('http://thief.com/steal_info')

    def test_authorized_request_only_if_access_token(self):
        s = Session('abc', '123')
        with self.assertRaises(Exception):
            s.authorized_request('http://thief.com/steal_info')
