from pybox.folder import *
from pybox import api

class Client(object):
    """ Client for the Box API """

    def __init__(self, session):
        self.session = session

    @property
    def root(self):
        return self.folder_by_id('0')

    def folder_by_id(self, folder_id):
        return Folder(self.session, api.get_folder_by_id(self.session, folder_id))

    def folder(self, folder_path):
        f = self.path(folder_path)
        assert type(f) == Folder
        return f

    def file_by_id(self, file_id):
        return File(self.session, api.get_file_by_id(self.session, file_id))

    def file(self, file_path):
        f = self.path(file_path)
        assert type(f) == File
        return f

    def path(self, path):
        path = path.lstrip('/').rstrip('/')
        return reduce(lambda folder,subpath: folder[subpath], path.split('/'), self.root)

    def upload_file(self, file_path, folder_path):
        folder = self.path(folder_path)
        with open(file_path, mode='r') as fp:
            return folder.upload(fp, file_path.split('/')[-1])

    def create_folder(self, folder_path):
        folder_path = folder_path.lstrip('/').rstrip('/')

        def reducer(folder, subpath):
            if subpath not in folder:
                return folder.create_subfolder(subpath)
            else:
                return folder[subpath]

        return reduce(reducer, folder_path.split('/'), self.root)


