import os
import tempfile
import subprocess
from lxml import etree


def save(text):
    fd, filename = tempfile.mkstemp()
    os.write(fd, text)
    os.close(fd)
    return filename

def less(text):
    filename = save(text)
    subprocess.call('less %s' % filename, shell=True)
    os.unlink(filename)

def grep(text, args):
    filename = save(text)
    subprocess.call('ack-grep %s %s' % (args, filename), shell=True)
    os.unlink(filename)

def xmlformat(text, encoding='utf-8'):
    tree = etree.fromstring(text)
    return etree.tostring(tree, encoding=encoding, pretty_print=True)

def uprint(value):
    if hasattr(value, '__iter__'):
        print _print(value)
    else:
        print repr(value)

def _print(seq):

    def _repr(value):
        if hasattr(value, '__iter__'):
            return _print(value)
        return u'"%s"' % value.replace(u'"', u'\\"') 

    if isinstance(seq, tuple):
        template = u'(%s,)'
        return template % ', '.join([_repr(item) for item in seq])
    elif isinstance(seq, list):
        template = u'[%s,]'
        return template % ', '.join([_repr(item) for item in seq])
    elif isinstance(seq, dict):
        template = u'{%s,}'
        return template % ', '.join([u"%s:%s" % (_repr(k), _repr(v)) for k,v in seq.iteritems()])
    else:
        return repr(seq)


