import os
import tempfile
import subprocess
import sys
from lxml import etree
from pprint import PrettyPrinter


def save(text):
    fd, filename = tempfile.mkstemp()
    os.write(fd, text)
    os.close(fd)
    return filename

def less(text):
    filename = save(text)
    subprocess.call('less %s' % filename, shell=True)
    os.unlink(filename)

def grep(text, args):
    filename = save(text)
    subprocess.call('ack-grep %s %s' % (args, filename), shell=True)
    os.unlink(filename)

def xmlformat(text, encoding='utf-8'):
    tree = etree.fromstring(text)
    return etree.tostring(tree, encoding=encoding, pretty_print=True)

def pprint(obj, stream=None, indent=1, width=80, depth=None):

    class _PrettyPrinter(PrettyPrinter):
        def format(self, *args, **kwargs):
            repr, readable, recursive = PrettyPrinter.format(self, *args, **kwargs)
            if repr:
                if repr[0] in ('"', "'"):
                    repr = repr.decode('string_escape')
                elif repr[0:2] in ("u'", 'u"'):
                    repr = repr.decode('unicode_escape').encode(sys.stdout.encoding)
            return repr, readable, recursive

    printer = _PrettyPrinter(stream=stream, indent=indent, width=width, depth=depth)
    printer.pprint(obj)

def uprint(value):
    if hasattr(value, '__iter__'):
        print _print(value)
    else:
        print repr(value)

def _print(seq):

    def _repr(value):
        if hasattr(value, '__iter__'):
            return _print(value)
        return u'"%s"' % value.replace(u'"', u'\\"') 

    if isinstance(seq, tuple):
        template = u'(%s,)'
        return template % ', '.join([_repr(item) for item in seq])
    elif isinstance(seq, list):
        template = u'[%s,]'
        return template % ', '.join([_repr(item) for item in seq])
    elif isinstance(seq, dict):
        template = u'{%s,}'
        return template % ', '.join([u"%s:%s" % (_repr(k), _repr(v)) for k,v in seq.iteritems()])
    else:
        return repr(seq)


