import os
import tempfile
import subprocess
from lxml import etree


def save(text):
    fd, filename = tempfile.mkstemp()
    os.write(fd, text)
    os.close(fd)
    return filename

def less(text):
    filename = save(text)
    subprocess.call('less %s' % filename, shell=True)
    os.unlink(filename)

def grep(text, args):
    filename = save(text)
    subprocess.call('ack-grep %s %s' % (args, filename), shell=True)
    os.unlink(filename)

def xmlformat(text, encoding='utf-8'):
    tree = etree.fromstring(text)
    return etree.tostring(tree, encoding=encoding, pretty_print=True)

