# -*- coding: utf-8 -*- 

class BindingSpec(object):
    """
    Basic interface for binding specifications.
    """
    def configure(self, bind):
        """
        Should implement binding instructions, e.g.::

            bind('widget').annotated_with('text').to_class(TextWidget).as_prototype()

        :param bind: A reference to the :meth:`~di.contexts.Injector.bind` method of the related context.
        :type bind: :class:`types.FunctionType`
        """
        raise NotImplemented