#!/usr/bin/env python
# -*- coding: utf-8 -*-

# http://wiki.cython.org/enhancements/distutils_preprocessing
# http://wiki.cython.org/BuildingWindowsInstaller

# from ez_setup import use_setuptools
# use_setuptools()
# from setuptools import Command
# from setuptools.command.build_ext import build_ext
# from Cython.Distutils import build_ext

#from distutils.core import setup
#from distutils.extension import Extension

from setuptools import setup
from setuptools import Extension
from Cython.Build import cythonize
import numpy
import os
import string

textfiles = [f for f in os.listdir(os.path.abspath(os.path.dirname(__file__))) if f.lower().endswith(".txt")]
for filename in textfiles:
    with open(filename, "rb") as f:
        data = f.read()
    temp = data.replace('\r\n', '\n')
    temp = temp.replace('\r', '\n')
    temp = temp.replace('\n', '\r\n')
    if not data == temp:
        with open(filename, "wb") as f:
            f.write(temp)
            print "changed", filename

__version__ = "Undefined"
for line in open('pydna/__init__.py'):
    if (line.startswith('__all__')):
        break
    exec(line.strip())


setup(  name='python-dna',
        version         =__version__,
        author          =__author__,
        author_email    =__email__,
        packages=['pydna'],
        #ext_modules=[Extension('pydna.find_sub_strings', ['pydna/findsubstrings_numpy_arrays.c'])],
        ext_modules = cythonize([Extension('pydna.find_sub_strings', ['pydna/findsubstrings_numpy_arrays.c'],include_dirs=[numpy.get_include()])]),
        #scripts=[],
        url='http://pypi.python.org/pypi/python-dna/',
        license='LICENSE.txt',
        description='''Contains classes and code for representing double
                     stranded DNA and functions for simulating homologous
                     recombination between DNA molecules.''',
        long_description=open('README.txt').read(),
        install_requires =[ "networkx>=1.7", "biopython>=1.6",],
        test_suite="run_tests.load_my_tests",
        )


# https://readthedocs.org/



'''
http://guide.python-distribute.org/introduction.html
http://pypi.python.org/pypi/distribute#installation-instructions
http://alexis.notmyidea.org/distutils2/setupcfg.html#complete-example


'''