#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright 2013 by Björn Johansson.  All rights reserved.
# This code is part of the Python-dna distribution and governed by its
# license.  Please see the LICENSE.txt file that should have been included
# as part of this package.

__author__       = "Björn Johansson"
__date__         = "2013-01-09"
__copyright__    = "Copyright 2013, Björn Johansson"
__credits__      = ["Björn Johansson"]
__license__      = "BSD"
__version__      = "0.0.7"
__maintainer__   = "Björn Johansson"
__email__        = "bjorn_johansson@bio.uminho.pt"
__status__       = "Development" # "Production" #"Prototype" # "Production"

__all__ = [ "Ape",
            "Anneal",
            "linear_assembly",
            "circular_assembly",
            "dseq",
            "drecord",
            "Genbank",
            "eq",
            "shift_origin",
            "copy_features",
            "parse",
            "pcr",
            "read",
            "sync",
            "common_sub_strings",]

from pydna.find_sub_strings    import common_sub_strings
from pydna.assembly            import linear_assembly
from pydna.assembly            import circular_assembly
from pydna.dsdna               import dseq
from pydna.dsdna               import drecord
from pydna.dsdna               import parse
from pydna.dsdna               import read
from pydna.editor              import Ape
from pydna.amplify             import Anneal
from pydna.amplify             import pcr
from pydna.utils               import eq
from pydna.utils               import sync
from pydna.utils               import shift_origin
from pydna.utils               import copy_features
from pydna.download            import Genbank