#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
test empty
'''

import unittest
from pydna import drecord,dseq, parse, read,  eq
from Bio.Seq import Seq

class test_dsdna(unittest.TestCase):

    def test_linear_circular(self):
        ''' test drecord linear & circular property'''

        a=drecord("attt")
        self.assertTrue(a.linear     == True)
        self.assertTrue(a.circular   == False)
        self.assertTrue( a.verify_stamp()  == False)
        a.stamp()
        self.assertTrue( a.verify_stamp()  == True)
        rc = a.rc()
        self.assertTrue( str(rc.seq) == "aaat")
        a.linear = False
        self.assertTrue(a.linear     == False)
        self.assertTrue(a.circular   == True)
        a.linear = True
        self.assertTrue(a.linear     == True)
        self.assertTrue(a.circular   == False)
        a.circular = True
        self.assertTrue(a.linear     == False)
        self.assertTrue(a.circular   == True)
        a.circular = False
        self.assertTrue(a.linear     == True)
        self.assertTrue(a.circular   == False)

        a.circular = True
        b = drecord(a)

        self.assertTrue(b.linear     == False)
        self.assertTrue(b.circular   == True)
        b.circular = False
        self.assertTrue(b.linear     == True)
        self.assertTrue(b.circular   == False)

        self.assertTrue(a.circular   == True)

        d=drecord("aatt", circular = True)
        self.assertTrue(d.linear     == False)
        self.assertTrue(d.circular   == True)

        d=drecord("aatt", circular = False)
        self.assertTrue(d.linear     == True)
        self.assertTrue(d.circular   == False)

        d=drecord("aatt", linear = True)
        self.assertTrue(d.linear     == True)
        self.assertTrue(d.circular   == False)


        d=drecord("aatt", linear = False)
        self.assertTrue(d.linear     == False)
        self.assertTrue(d.circular   == True)

        e= d.rc()
        self.assertTrue(e.linear     == False)
        self.assertTrue(e.circular   == True)

        e= d.reverse_complement()
        self.assertTrue(e.linear     == False)
        self.assertTrue(e.circular   == True)

    def dseq_test_cutting_adding(self):

        from Bio.Seq import Seq
        from Bio.Restriction import BamHI,EcoRI, PstI, EcoRV, SmaI
        from Bio.Alphabet.IUPAC import IUPACAmbiguousDNA
        from Bio.SeqUtils.CheckSum import seguid
        from pydna import dseq


        a = dseq('GGATCCtcatctactatcatcgtagcgtactgatctattctgctgctcatcatcggtactctctataattatatatatatgcgcgtGGATCC',
                 'CCTAGGagtagatgatagtagcatcgcatgactagataagacgacgagtagtagccatgagagatattaatatatatatacgcgcaCCTAGG'[::-1],
                 linear=True,
                 ovhg=0)
        b = a.cut(BamHI)[1]

        self.assertEqual( b.watson , "GATCCtcatctactatcatcgtagcgtactgatctattctgctgctcatcatcggtactctctataattatatatatatgcgcgtG".upper())
        self.assertEqual( b.crick  , "GATCCacgcgcatatatatataattatagagagtaccgatgatgagcagcagaatagatcagtacgctacgatgatagtagatgaG".upper())

        c = dseq('nCTGCAGtcatctactatcatcgtagcgtactgatctattctgctgctcatcatcggtactctctataattatatatatatgcgcgtGAATTCn',
                 'nGACGTCagtagatgatagtagcatcgcatgactagataagacgacgagtagtagccatgagagatattaatatatatatacgcgcaCTTAAGn'[::-1],
                 linear=True,
                 ovhg=0)

        f,d,l = c.cut((EcoRI, PstI))

        self.assertEqual( d.watson  , "GtcatctactatcatcgtagcgtactgatctattctgctgctcatcatcggtactctctataattatatatatatgcgcgtG".upper())
        self.assertEqual( d.crick   , "AATTCacgcgcatatatatataattatagagagtaccgatgatgagcagcagaatagatcagtacgctacgatgatagtagatgaCTGCA".upper())


        e =    dseq("nGAATTCtcatctactatcatcgtagcgtactgatctattctgctgctcatcatcggtactctctataattatatatatatgcgcgtCTGCAGn",
                    "nCTTAAGagtagatgatagtagcatcgcatgactagataagacgacgagtagtagccatgagagatattaatatatatatacgcgcaGACGTCn"[::-1],
                    linear=True,
                    ovhg=0)

        f = e.cut((EcoRI,PstI))[1]

        self.assertEqual( f.watson ,"AATTCtcatctactatcatcgtagcgtactgatctattctgctgctcatcatcggtactctctataattatatatatatgcgcgtCTGCA".upper())
        self.assertEqual( f.crick  , "GacgcgcatatatatataattatagagagtaccgatgatgagcagcagaatagatcagtacgctacgatgatagtagatgaG".upper())



        ''' blunt cloning '''


        pUC19 = read("./pUC19.gb")

        self.assertFalse( pUC19.linear )

        self.assertTrue( len(pUC19) == 2686 )
        self.assertTrue( len(pUC19.seq.watson) == 2686 )
        self.assertTrue( len(pUC19.seq.crick) == 2686 )

        self.assertTrue( pUC19.seq.circular == True)
        self.assertTrue( pUC19.seq.linear   == False)

        pUC19_SmaI = pUC19.cut(SmaI)
        self.assertTrue( len(pUC19_SmaI) == 1)
        pUC19_SmaI = pUC19_SmaI.pop()


        self.assertTrue( pUC19_SmaI.linear )
        self.assertTrue( len(pUC19_SmaI) == 2686 )
        self.assertTrue( pUC19_SmaI.linear )

        #print type(a)
        #print type(pUC19_SmaI)
        pUC19_SmaI_a = pUC19_SmaI.seq + a  #<-----!!!!! solve adding dseq to drecord etc...

        self.assertTrue(  pUC19_SmaI_a.linear   )
        self.assertFalse( pUC19_SmaI_a.circular )

        pUC19_SmaI_a.loop()
        self.assertTrue( len(pUC19_SmaI_a) == 2778 )

        self.assertTrue(  pUC19_SmaI_a.circular )
        self.assertFalse( pUC19_SmaI_a.linear   )
        self.assertTrue( eq(pUC19_SmaI_a, read("./pUC19-SmaI-a.gb")   ))

        ''' sticky end cloning '''

        pUC19_BamHI = pUC19.cut(BamHI)

        self.assertTrue( len(pUC19_BamHI) == 1)

        pUC19_BamHI = pUC19_BamHI.pop().seq

        self.assertTrue( len(pUC19_BamHI.watson) == len(pUC19_BamHI.crick) == 2686 )

        pUC19_BamHI_a = pUC19_BamHI+b

        self.assertTrue( len(pUC19_BamHI_a.watson) == len(pUC19_BamHI_a.crick) == 2772 )

        self.assertTrue( pUC19_BamHI_a.circular == False)
        self.assertTrue( pUC19_BamHI_a.linear   == True)

        pUC19_BamHI_a.loop()

        self.assertTrue( pUC19_BamHI_a.circular == True)
        self.assertTrue( pUC19_BamHI_a.linear   == False)

        self.assertTrue( eq(pUC19_BamHI_a, read("./pUC19-BamHI-a.gb")))

        pUC19_BamHI_a_rc = pUC19_BamHI+b.rc()

        pUC19_BamHI_a_rc.loop()

        self.assertTrue( pUC19_BamHI_a.circular == True)
        self.assertTrue( pUC19_BamHI_a.linear   == False)
        self.assertTrue( eq(pUC19_BamHI_a_rc, read("./pUC19-BamHI-a-rc.gb")))

        ''' adding (ligating) dsDNA objects '''
        a+a
        b+b
        with self.assertRaisesRegexp(TypeError, "circular"):
            pUC19+a
        with self.assertRaisesRegexp(TypeError, "circular"):
            a+pUC19
        with self.assertRaisesRegexp(TypeError, "compatible"):
            a+b
        with self.assertRaisesRegexp(TypeError, "compatible"):
            b+a
        with self.assertRaisesRegexp(TypeError, "compatible"):
            d+d
        d+d.rc()
        d.rc()+d


        ''' directional cloning '''

        pUC19_EcoRI_PstI = pUC19.cut(EcoRI,PstI).pop().seq

        with self.assertRaisesRegexp(TypeError, "compatible"):
            pUC19_EcoRI_PstI + d

        pUC19_EcoRI_PstI_d = pUC19_EcoRI_PstI + d.rc()
        pUC19_EcoRI_PstI_d.loop()

        self.assertTrue( eq(pUC19_EcoRI_PstI_d, read("./pUC19-EcoRI_PstI-d-rc.gb")))
        self.assertTrue( eq(pUC19_EcoRI_PstI_d.rc(), read("./pUC19-EcoRI_PstI-d-rc.gb")))


    def test_drecord_cutting_adding(self):

        from Bio.Seq import Seq
        from Bio.Restriction import Bsu36I, BstAPI
        from Bio.Alphabet.IUPAC import IUPACAmbiguousDNA
        from Bio.SeqUtils.CheckSum import seguid

        pCAPs = read("./pCAPs.gb")

        a,b = pCAPs.cut(Bsu36I, BstAPI)

        c=a+b

        c.loop()

        self.assertTrue( eq(c, pCAPs) )

        #from helper import ape

        #ape((pCAPs,c))



    def test_dseq_slicing(self):
        from Bio.Restriction import BamHI
        a=dseq("ggatcc","ggatcc",0)

        self.assertEqual( a[:].watson, a.watson )
        self.assertEqual( a[:].crick, a.crick )
        self.assertEqual( a.ovhg, a[:].ovhg )

        b,c = a.cut(BamHI)

        d = b[1:5]

        e = d.rc()

        self.assertEqual( d+e, dseq("gatc","gatc",0))


if __name__ == '__main__':
    runner = unittest.TextTestRunner(verbosity = 1)
    unittest.main(testRunner=runner)

