DEFS = {'architectures': {'create': {'architecture ': {'ptype': 'Hash',
                                                'required': True},
                              'architecture[name] ': {'ptype': 'String',
                                                      'required': True},
                              'architecture[operatingsystem_ids] ': {'ptype': 'Array',
                                                                     'required': False}},
                   'destroy': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                       'required': True}},
                   'index': {'order ': {'ptype': 'String',
                                        'required': False},
                             'page ': {'ptype': 'String', 'required': False},
                             'per_page ': {'ptype': 'String',
                                           'required': False},
                             'search ': {'ptype': 'String',
                                         'required': False}},
                   'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                    'required': True}},
                   'update': {'architecture ': {'ptype': 'Hash',
                                                'required': True},
                              'architecture[name] ': {'ptype': 'String',
                                                      'required': False},
                              'architecture[operatingsystem_ids] ': {'ptype': 'Array',
                                                                     'required': False},
                              'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                      'required': True}}},
 'audits': {'index': {'order ': {'ptype': 'String', 'required': False},
                      'page ': {'ptype': 'String', 'required': False},
                      'per_page ': {'ptype': 'String', 'required': False},
                      'search ': {'ptype': 'String', 'required': False}},
            'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                             'required': True}}},
 'auth_source_ldaps': {'create': {'auth_source_ldap ': {'ptype': 'Hash',
                                                        'required': True},
                                  'auth_source_ldap[account] ': {'ptype': 'String',
                                                                 'required': False},
                                  'auth_source_ldap[account_password] ': {'ptype': 'String',
                                                                          'required': True},
                                  'auth_source_ldap[attr_firstname] ': {'ptype': 'String',
                                                                        'required': True},
                                  'auth_source_ldap[attr_lastname] ': {'ptype': 'String',
                                                                       'required': True},
                                  'auth_source_ldap[attr_login] ': {'ptype': 'String',
                                                                    'required': True},
                                  'auth_source_ldap[attr_mail] ': {'ptype': 'String',
                                                                   'required': True},
                                  'auth_source_ldap[base_dn] ': {'ptype': 'String',
                                                                 'required': False},
                                  'auth_source_ldap[host] ': {'ptype': 'String',
                                                              'required': True},
                                  'auth_source_ldap[name] ': {'ptype': 'String',
                                                              'required': True},
                                  'auth_source_ldap[onthefly_register] ': {'ptype': "'true' or 'false'",
                                                                           'required': False},
                                  'auth_source_ldap[port] ': {'ptype': 'number.',
                                                              'required': False},
                                  'auth_source_ldap[tls] ': {'ptype': "'true' or 'false'",
                                                             'required': False}},
                       'destroy': {'id ': {'ptype': 'String',
                                           'required': True}},
                       'index': {'page ': {'ptype': 'String',
                                           'required': False},
                                 'per_page ': {'ptype': 'String',
                                               'required': False}},
                       'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                        'required': True}},
                       'update': {'auth_source_ldap ': {'ptype': 'Hash',
                                                        'required': True},
                                  'auth_source_ldap[account] ': {'ptype': 'String',
                                                                 'required': False},
                                  'auth_source_ldap[account_password] ': {'ptype': 'String',
                                                                          'required': True},
                                  'auth_source_ldap[attr_firstname] ': {'ptype': 'String',
                                                                        'required': True},
                                  'auth_source_ldap[attr_lastname] ': {'ptype': 'String',
                                                                       'required': True},
                                  'auth_source_ldap[attr_login] ': {'ptype': 'String',
                                                                    'required': True},
                                  'auth_source_ldap[attr_mail] ': {'ptype': 'String',
                                                                   'required': True},
                                  'auth_source_ldap[base_dn] ': {'ptype': 'String',
                                                                 'required': False},
                                  'auth_source_ldap[host] ': {'ptype': 'String',
                                                              'required': False},
                                  'auth_source_ldap[name] ': {'ptype': 'String',
                                                              'required': False},
                                  'auth_source_ldap[onthefly_register] ': {'ptype': "'true' or 'false'",
                                                                           'required': False},
                                  'auth_source_ldap[port] ': {'ptype': 'number.',
                                                              'required': False},
                                  'auth_source_ldap[tls] ': {'ptype': "'true' or 'false'",
                                                             'required': False},
                                  'id ': {'ptype': 'String',
                                          'required': True}}},
 'bookmarks': {'create': {'bookmark ': {'ptype': 'Hash', 'required': True},
                          'bookmark[controller] ': {'ptype': 'String',
                                                    'required': True},
                          'bookmark[name] ': {'ptype': 'String',
                                              'required': True},
                          'bookmark[public] ': {'ptype': "'true' or 'false'",
                                                'required': False},
                          'bookmark[query] ': {'ptype': 'String',
                                               'required': True}},
               'destroy': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                   'required': True}},
               'index': {'page ': {'ptype': 'String', 'required': False},
                         'per_page ': {'ptype': 'String', 'required': False}},
               'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                'required': True}},
               'update': {'bookmark ': {'ptype': 'Hash', 'required': True},
                          'bookmark[controller] ': {'ptype': 'String',
                                                    'required': False},
                          'bookmark[name] ': {'ptype': 'String',
                                              'required': False},
                          'bookmark[public] ': {'ptype': "'true' or 'false'",
                                                'required': False},
                          'bookmark[query] ': {'ptype': 'String',
                                               'required': False},
                          'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                  'required': True}}},
 'common_parameters': {'create': {'common_parameter ': {'ptype': 'Hash',
                                                        'required': True},
                                  'common_parameter[name] ': {'ptype': 'String',
                                                              'required': True},
                                  'common_parameter[value] ': {'ptype': 'String',
                                                               'required': True}},
                       'destroy': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                           'required': True}},
                       'index': {'order ': {'ptype': 'String',
                                            'required': False},
                                 'page ': {'ptype': 'String',
                                           'required': False},
                                 'per_page ': {'ptype': 'String',
                                               'required': False},
                                 'search ': {'ptype': 'String',
                                             'required': False}},
                       'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                        'required': True}},
                       'update': {'common_parameter ': {'ptype': 'Hash',
                                                        'required': True},
                                  'common_parameter[name] ': {'ptype': 'String',
                                                              'required': False},
                                  'common_parameter[value] ': {'ptype': 'String',
                                                               'required': False},
                                  'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                          'required': True}}},
 'compute_resources': {'create': {'compute_resource ': {'ptype': 'Hash',
                                                        'required': True},
                                  'compute_resource[description] ': {'ptype': 'String',
                                                                     'required': False},
                                  'compute_resource[name] ': {'ptype': 'String',
                                                              'required': False},
                                  'compute_resource[password] ': {'ptype': 'String',
                                                                  'required': False},
                                  'compute_resource[provider] ': {'ptype': 'String',
                                                                  'required': False},
                                  'compute_resource[region] ': {'ptype': 'String',
                                                                'required': False},
                                  'compute_resource[server] ': {'ptype': 'String',
                                                                'required': False},
                                  'compute_resource[tenant] ': {'ptype': 'String',
                                                                'required': False},
                                  'compute_resource[url] ': {'ptype': 'String',
                                                             'required': True},
                                  'compute_resource[user] ': {'ptype': 'String',
                                                              'required': False},
                                  'compute_resource[uuid] ': {'ptype': 'String',
                                                              'required': False}},
                       'destroy': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                           'required': True}},
                       'index': {'order ': {'ptype': 'String',
                                            'required': False},
                                 'page ': {'ptype': 'String',
                                           'required': False},
                                 'per_page ': {'ptype': 'String',
                                               'required': False},
                                 'search ': {'ptype': 'String',
                                             'required': False}},
                       'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                        'required': True}},
                       'update': {'compute_resource ': {'ptype': 'Hash',
                                                        'required': True},
                                  'compute_resource[description] ': {'ptype': 'String',
                                                                     'required': False},
                                  'compute_resource[name] ': {'ptype': 'String',
                                                              'required': False},
                                  'compute_resource[password] ': {'ptype': 'String',
                                                                  'required': False},
                                  'compute_resource[provider] ': {'ptype': 'String',
                                                                  'required': False},
                                  'compute_resource[region] ': {'ptype': 'String',
                                                                'required': False},
                                  'compute_resource[server] ': {'ptype': 'String',
                                                                'required': False},
                                  'compute_resource[tenant] ': {'ptype': 'String',
                                                                'required': False},
                                  'compute_resource[url] ': {'ptype': 'String',
                                                             'required': False},
                                  'compute_resource[user] ': {'ptype': 'String',
                                                              'required': False},
                                  'compute_resource[uuid] ': {'ptype': 'String',
                                                              'required': False},
                                  'id ': {'ptype': 'String',
                                          'required': True}}},
 'config_templates': {'build_pxe_default': {},
                      'create': {'config_template ': {'ptype': 'Hash',
                                                      'required': True},
                                 'config_template[audit_comment] ': {'ptype': 'String',
                                                                     'required': False},
                                 'config_template[name] ': {'ptype': 'String',
                                                            'required': True},
                                 'config_template[operatingsystem_ids] ': {'ptype': 'Array',
                                                                           'required': False},
                                 'config_template[snippet] ': {'ptype': "'true' or 'false'",
                                                               'required': False},
                                 'config_template[template] ': {'ptype': 'String',
                                                                'required': True},
                                 'config_template[template_combinations_attributes] ': {'ptype': 'Array',
                                                                                        'required': False},
                                 'config_template[template_kind_id] ': {'ptype': 'number.',
                                                                        'required': False}},
                      'destroy': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                          'required': True}},
                      'index': {'order ': {'ptype': 'String',
                                           'required': False},
                                'page ': {'ptype': 'String',
                                          'required': False},
                                'per_page ': {'ptype': 'String',
                                              'required': False},
                                'search ': {'ptype': 'String',
                                            'required': False}},
                      'revision': {'version ': {'ptype': 'String',
                                                'required': False}},
                      'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                       'required': True}},
                      'update': {'config_template ': {'ptype': 'Hash',
                                                      'required': True},
                                 'config_template[audit_comment] ': {'ptype': 'String',
                                                                     'required': False},
                                 'config_template[name] ': {'ptype': 'String',
                                                            'required': False},
                                 'config_template[operatingsystem_ids] ': {'ptype': 'Array',
                                                                           'required': False},
                                 'config_template[snippet] ': {'ptype': "'true' or 'false'",
                                                               'required': False},
                                 'config_template[template] ': {'ptype': 'String',
                                                                'required': False},
                                 'config_template[template_combinations_attributes] ': {'ptype': 'Array',
                                                                                        'required': False},
                                 'config_template[template_kind_id] ': {'ptype': 'number.',
                                                                        'required': False},
                                 'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                         'required': True}}},
 'dashboard': {'index': {'search ': {'ptype': 'String', 'required': False}}},
 'domains': {'create': {'domain ': {'ptype': 'Hash', 'required': True},
                        'domain[dns_id] ': {'ptype': 'number.',
                                            'required': False},
                        'domain[domain_parameters_attributes] ': {'ptype': 'Array',
                                                                  'required': False},
                        'domain[fullname] ': {'ptype': 'String',
                                              'required': False},
                        'domain[name] ': {'ptype': 'String',
                                          'required': True}},
             'destroy': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                 'required': True}},
             'index': {'order ': {'ptype': 'String', 'required': False},
                       'page ': {'ptype': 'String', 'required': False},
                       'per_page ': {'ptype': 'String', 'required': False},
                       'search ': {'ptype': 'String', 'required': False}},
             'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                              'required': True}},
             'update': {'domain ': {'ptype': 'Hash', 'required': True},
                        'domain[dns_id] ': {'ptype': 'number.',
                                            'required': False},
                        'domain[domain_parameters_attributes] ': {'ptype': 'Array',
                                                                  'required': False},
                        'domain[fullname] ': {'ptype': 'String',
                                              'required': False},
                        'domain[name] ': {'ptype': 'String',
                                          'required': False},
                        'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                'required': True}}},
 'environments': {'create': {'environment ': {'ptype': 'Hash',
                                              'required': True},
                             'environment[name] ': {'ptype': 'String',
                                                    'required': True}},
                  'destroy': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                      'required': True}},
                  'index': {'order ': {'ptype': 'String', 'required': False},
                            'page ': {'ptype': 'String', 'required': False},
                            'per_page ': {'ptype': 'String',
                                          'required': False},
                            'search ': {'ptype': 'String',
                                        'required': False}},
                  'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                   'required': True}},
                  'update': {'environment ': {'ptype': 'Hash',
                                              'required': True},
                             'environment[name] ': {'ptype': 'String',
                                                    'required': False},
                             'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                     'required': True}}},
 'fact_values': {'index': {'order ': {'ptype': 'String', 'required': False},
                           'page ': {'ptype': 'String', 'required': False},
                           'per_page ': {'ptype': 'String',
                                         'required': False},
                           'search ': {'ptype': 'String', 'required': False}}},
 'home': {'index': {}, 'status': {}},
 'hostgroups': {'create': {'hostgroup ': {'ptype': 'Hash', 'required': True},
                           'hostgroup[architecture_id] ': {'ptype': 'number.',
                                                           'required': False},
                           'hostgroup[domain_id] ': {'ptype': 'number.',
                                                     'required': False},
                           'hostgroup[environment_id] ': {'ptype': 'number.',
                                                          'required': False},
                           'hostgroup[medium_id] ': {'ptype': 'number.',
                                                     'required': False},
                           'hostgroup[name] ': {'ptype': 'String',
                                                'required': True},
                           'hostgroup[operatingsystem_id] ': {'ptype': 'number.',
                                                              'required': False},
                           'hostgroup[ptable_id] ': {'ptype': 'number.',
                                                     'required': False},
                           'hostgroup[puppet_ca_proxy_id] ': {'ptype': 'number.',
                                                              'required': False},
                           'hostgroup[puppet_proxy_id] ': {'ptype': 'number.',
                                                           'required': False},
                           'hostgroup[subnet_id] ': {'ptype': 'number.',
                                                     'required': False}},
                'destroy': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                    'required': True}},
                'index': {'order ': {'ptype': 'String', 'required': False},
                          'page ': {'ptype': 'String', 'required': False},
                          'per_page ': {'ptype': 'String',
                                        'required': False},
                          'search ': {'ptype': 'String', 'required': False}},
                'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                 'required': True}},
                'update': {'hostgroup ': {'ptype': 'Hash', 'required': True},
                           'hostgroup[architecture_id] ': {'ptype': 'number.',
                                                           'required': False},
                           'hostgroup[domain_id] ': {'ptype': 'number.',
                                                     'required': False},
                           'hostgroup[environment_id] ': {'ptype': 'number.',
                                                          'required': False},
                           'hostgroup[medium_id] ': {'ptype': 'number.',
                                                     'required': False},
                           'hostgroup[name] ': {'ptype': 'String',
                                                'required': False},
                           'hostgroup[operatingsystem_id] ': {'ptype': 'number.',
                                                              'required': False},
                           'hostgroup[ptable_id] ': {'ptype': 'number.',
                                                     'required': False},
                           'hostgroup[puppet_ca_proxy_id] ': {'ptype': 'number.',
                                                              'required': False},
                           'hostgroup[puppet_proxy_id] ': {'ptype': 'number.',
                                                           'required': False},
                           'hostgroup[subnet_id] ': {'ptype': 'number.',
                                                     'required': False},
                           'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                   'required': True}}},
 'hosts': {'create': {'host ': {'ptype': 'Hash', 'required': True},
                      'host[architecture_id] ': {'ptype': 'number.',
                                                 'required': True},
                      'host[domain_id] ': {'ptype': 'number.',
                                           'required': True},
                      'host[environment_id] ': {'ptype': 'String',
                                                'required': True},
                      'host[host_parameters_attributes] ': {'ptype': 'Array',
                                                            'required': False},
                      'host[hostgroup_id] ': {'ptype': 'number.',
                                              'required': False},
                      'host[image_id] ': {'ptype': 'number.',
                                          'required': False},
                      'host[ip] ': {'ptype': 'String', 'required': True},
                      'host[mac] ': {'ptype': 'String', 'required': True},
                      'host[medium_id] ': {'ptype': 'number.',
                                           'required': False},
                      'host[model_id_id] ': {'ptype': 'number.',
                                             'required': False},
                      'host[name] ': {'ptype': 'String', 'required': True},
                      'host[operatingsystem_id] ': {'ptype': 'String',
                                                    'required': True},
                      'host[owner_id] ': {'ptype': 'number.',
                                          'required': False},
                      'host[ptable_id] ': {'ptype': 'number.',
                                           'required': False},
                      'host[puppet_ca_proxy_id] ': {'ptype': 'number.',
                                                    'required': False},
                      'host[puppet_proxy_id] ': {'ptype': 'number.',
                                                 'required': True},
                      'host[sp_subnet_id] ': {'ptype': 'number.',
                                              'required': False},
                      'host[subnet_id] ': {'ptype': 'number.',
                                           'required': False}},
           'destroy': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                               'required': True}},
           'index': {'order ': {'ptype': 'String', 'required': False},
                     'page ': {'ptype': 'String', 'required': False},
                     'per_page ': {'ptype': 'String', 'required': False},
                     'search ': {'ptype': 'String', 'required': False}},
           'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, dot(.), space, underscore(_), hypen(-) with no leading or trailing space.',
                            'required': True}},
           'status': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, dot(.), space, underscore(_), hypen(-) with no leading or trailing space.',
                              'required': True}},
           'update': {'host ': {'ptype': 'Hash', 'required': True},
                      'host[architecture_id] ': {'ptype': 'number.',
                                                 'required': False},
                      'host[domain_id] ': {'ptype': 'number.',
                                           'required': False},
                      'host[environment_id] ': {'ptype': 'String',
                                                'required': False},
                      'host[host_parameters_attributes] ': {'ptype': 'Array',
                                                            'required': False},
                      'host[hostgroup_id] ': {'ptype': 'number.',
                                              'required': False},
                      'host[image_id] ': {'ptype': 'number.',
                                          'required': False},
                      'host[ip] ': {'ptype': 'String', 'required': True},
                      'host[mac] ': {'ptype': 'String', 'required': True},
                      'host[medium_id] ': {'ptype': 'number.',
                                           'required': False},
                      'host[model_id_id] ': {'ptype': 'number.',
                                             'required': False},
                      'host[name] ': {'ptype': 'String', 'required': False},
                      'host[operatingsystem_id] ': {'ptype': 'String',
                                                    'required': False},
                      'host[owner_id] ': {'ptype': 'number.',
                                          'required': False},
                      'host[ptable_id] ': {'ptype': 'number.',
                                           'required': False},
                      'host[puppet_ca_proxy_id] ': {'ptype': 'number.',
                                                    'required': False},
                      'host[puppet_proxy_id] ': {'ptype': 'number.',
                                                 'required': False},
                      'host[sp_subnet_id] ': {'ptype': 'number.',
                                              'required': False},
                      'host[subnet_id] ': {'ptype': 'number.',
                                           'required': False},
                      'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                              'required': True}}},
 'images': {'create': {'compute_resource_id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                                'required': True},
                       'image ': {'ptype': 'Hash', 'required': True},
                       'image[architecture_id] ': {'ptype': 'number.',
                                                   'required': True},
                       'image[compute_resource_id] ': {'ptype': 'number.',
                                                       'required': True},
                       'image[name] ': {'ptype': 'String', 'required': True},
                       'image[operatingsystem_id] ': {'ptype': 'number.',
                                                      'required': True},
                       'image[username] ': {'ptype': 'String',
                                            'required': True},
                       'image[uuid] ': {'ptype': 'String', 'required': True}},
            'destroy': {'compute_resource_id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                                 'required': True},
                        'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                'required': True}},
            'index': {'compute_resource_id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                               'required': True},
                      'order ': {'ptype': 'String', 'required': False},
                      'page ': {'ptype': 'String', 'required': False},
                      'per_page ': {'ptype': 'String', 'required': False},
                      'search ': {'ptype': 'String', 'required': False}},
            'show': {'compute_resource_id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                              'required': True},
                     'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                             'required': True}},
            'update': {'compute_resource_id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                                'required': True},
                       'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                               'required': True},
                       'image ': {'ptype': 'Hash', 'required': True},
                       'image[architecture_id] ': {'ptype': 'number.',
                                                   'required': False},
                       'image[compute_resource_id] ': {'ptype': 'number.',
                                                       'required': False},
                       'image[name] ': {'ptype': 'String',
                                        'required': False},
                       'image[operatingsystem_id] ': {'ptype': 'number.',
                                                      'required': False},
                       'image[username] ': {'ptype': 'String',
                                            'required': False},
                       'image[uuid] ': {'ptype': 'String',
                                        'required': False}}},
 'lookup_keys': {'create': {'lookup_key ': {'ptype': 'Hash',
                                            'required': True},
                            'lookup_key[default_value] ': {'ptype': 'String',
                                                           'required': False},
                            'lookup_key[description] ': {'ptype': 'String',
                                                         'required': False},
                            'lookup_key[key] ': {'ptype': 'String',
                                                 'required': True},
                            'lookup_key[lookup_values_count] ': {'ptype': 'number.',
                                                                 'required': False},
                            'lookup_key[path] ': {'ptype': 'String',
                                                  'required': False},
                            'lookup_key[puppetclass_id] ': {'ptype': 'number.',
                                                            'required': False}},
                 'destroy': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                     'required': True}},
                 'index': {'order ': {'ptype': 'String', 'required': False},
                           'page ': {'ptype': 'String', 'required': False},
                           'per_page ': {'ptype': 'String',
                                         'required': False},
                           'search ': {'ptype': 'String', 'required': False}},
                 'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                  'required': True}},
                 'update': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                    'required': True},
                            'lookup_key ': {'ptype': 'Hash',
                                            'required': True},
                            'lookup_key[default_value] ': {'ptype': 'String',
                                                           'required': False},
                            'lookup_key[description] ': {'ptype': 'String',
                                                         'required': False},
                            'lookup_key[key] ': {'ptype': 'String',
                                                 'required': False},
                            'lookup_key[lookup_values_count] ': {'ptype': 'number.',
                                                                 'required': False},
                            'lookup_key[path] ': {'ptype': 'String',
                                                  'required': False},
                            'lookup_key[puppetclass_id] ': {'ptype': 'number.',
                                                            'required': False}}},
 'media': {'create': {'medium ': {'ptype': 'Hash', 'required': True},
                      'medium[name] ': {'ptype': 'String', 'required': True},
                      'medium[os_family] ': {'ptype': 'String',
                                             'required': False},
                      'medium[path] ': {'ptype': 'String', 'required': True}},
           'destroy': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                               'required': True}},
           'index': {'order ': {'ptype': 'String', 'required': False},
                     'page ': {'ptype': 'String', 'required': False},
                     'per_page ': {'ptype': 'String', 'required': False},
                     'search ': {'ptype': 'String', 'required': False}},
           'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                            'required': True}},
           'update': {'id ': {'ptype': 'String', 'required': True},
                      'medium ': {'ptype': 'Hash', 'required': True},
                      'medium[name] ': {'ptype': 'String',
                                        'required': False},
                      'medium[os_family] ': {'ptype': 'String',
                                             'required': False},
                      'medium[path] ': {'ptype': 'String',
                                        'required': False}}},
 'models': {'create': {'model ': {'ptype': 'Hash', 'required': True},
                       'model[hardware_model] ': {'ptype': 'String',
                                                  'required': False},
                       'model[info] ': {'ptype': 'String',
                                        'required': False},
                       'model[name] ': {'ptype': 'String', 'required': True},
                       'model[vendor_class] ': {'ptype': 'String',
                                                'required': False}},
            'destroy': {'id ': {'ptype': 'String', 'required': True}},
            'index': {'order ': {'ptype': 'String', 'required': False},
                      'page ': {'ptype': 'String', 'required': False},
                      'per_page ': {'ptype': 'String', 'required': False},
                      'search ': {'ptype': 'String', 'required': False}},
            'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                             'required': True}},
            'update': {'id ': {'ptype': 'String', 'required': True},
                       'model ': {'ptype': 'Hash', 'required': True},
                       'model[hardware_model] ': {'ptype': 'String',
                                                  'required': False},
                       'model[info] ': {'ptype': 'String',
                                        'required': False},
                       'model[name] ': {'ptype': 'String',
                                        'required': False},
                       'model[vendor_class] ': {'ptype': 'String',
                                                'required': False}}},
 'operatingsystems': {'bootfiles': {'architecture ': {'ptype': 'String',
                                                      'required': False},
                                    'id ': {'ptype': 'String',
                                            'required': True},
                                    'medium ': {'ptype': 'String',
                                                'required': False}},
                      'create': {'operatingsystem ': {'ptype': 'Hash',
                                                      'required': True},
                                 'operatingsystem[family] ': {'ptype': 'String',
                                                              'required': False},
                                 'operatingsystem[major] ': {'ptype': 'String',
                                                             'required': True},
                                 'operatingsystem[minor] ': {'ptype': 'String',
                                                             'required': True},
                                 'operatingsystem[name] ': {'ptype': 'regular expression /\\A(\\S+)\\Z/.',
                                                            'required': True},
                                 'operatingsystem[release_name] ': {'ptype': 'String',
                                                                    'required': False}},
                      'destroy': {'id ': {'ptype': 'String',
                                          'required': True}},
                      'index': {'order ': {'ptype': 'String',
                                           'required': False},
                                'page ': {'ptype': 'String',
                                          'required': False},
                                'per_page ': {'ptype': 'String',
                                              'required': False},
                                'search ': {'ptype': 'String',
                                            'required': False}},
                      'show': {'id ': {'ptype': 'String', 'required': True}},
                      'update': {'id ': {'ptype': 'String',
                                         'required': True},
                                 'operatingsystem ': {'ptype': 'Hash',
                                                      'required': True},
                                 'operatingsystem[family] ': {'ptype': 'String',
                                                              'required': False},
                                 'operatingsystem[major] ': {'ptype': 'String',
                                                             'required': False},
                                 'operatingsystem[minor] ': {'ptype': 'String',
                                                             'required': False},
                                 'operatingsystem[name] ': {'ptype': 'regular expression /\\A(\\S+)\\Z/.',
                                                            'required': False},
                                 'operatingsystem[release_name] ': {'ptype': 'String',
                                                                    'required': False}}},
 'ptables': {'create': {'ptable ': {'ptype': 'Hash', 'required': True},
                        'ptable[layout] ': {'ptype': 'String',
                                            'required': True},
                        'ptable[name] ': {'ptype': 'String',
                                          'required': True},
                        'ptable[os_family] ': {'ptype': 'String',
                                               'required': False}},
             'destroy': {'id ': {'ptype': 'String', 'required': True}},
             'index': {'order ': {'ptype': 'String', 'required': False},
                       'page ': {'ptype': 'String', 'required': False},
                       'per_page ': {'ptype': 'String', 'required': False},
                       'search ': {'ptype': 'String', 'required': False}},
             'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                              'required': True}},
             'update': {'id ': {'ptype': 'String', 'required': True},
                        'ptable ': {'ptype': 'Hash', 'required': True},
                        'ptable[layout] ': {'ptype': 'String',
                                            'required': False},
                        'ptable[name] ': {'ptype': 'String',
                                          'required': False},
                        'ptable[os_family] ': {'ptype': 'String',
                                               'required': False}}},
 'puppetclasses': {'create': {'puppetclass ': {'ptype': 'Hash',
                                               'required': True},
                              'puppetclass[name] ': {'ptype': 'String',
                                                     'required': True}},
                   'destroy': {'id ': {'ptype': 'String', 'required': True}},
                   'index': {'order ': {'ptype': 'String',
                                        'required': False},
                             'page ': {'ptype': 'String', 'required': False},
                             'per_page ': {'ptype': 'String',
                                           'required': False},
                             'search ': {'ptype': 'String',
                                         'required': False}},
                   'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                    'required': True}},
                   'update': {'id ': {'ptype': 'String', 'required': True},
                              'puppetclass ': {'ptype': 'Hash',
                                               'required': True},
                              'puppetclass[name] ': {'ptype': 'String',
                                                     'required': False}}},
 'reports': {'destroy': {'id ': {'ptype': 'String', 'required': True}},
             'index': {'order ': {'ptype': 'String', 'required': False},
                       'page ': {'ptype': 'String', 'required': False},
                       'per_page ': {'ptype': 'String', 'required': False},
                       'search ': {'ptype': 'String', 'required': False}},
             'last': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                              'required': True}},
             'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                              'required': True}}},
 'roles': {'create': {'role ': {'ptype': 'Hash', 'required': True},
                      'role[name] ': {'ptype': 'String', 'required': True}},
           'destroy': {'id ': {'ptype': 'String', 'required': True}},
           'index': {'page ': {'ptype': 'String', 'required': False},
                     'per_page ': {'ptype': 'String', 'required': False}},
           'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                            'required': True}},
           'update': {'id ': {'ptype': 'String', 'required': True},
                      'role ': {'ptype': 'Hash', 'required': True},
                      'role[name] ': {'ptype': 'String', 'required': False}}},
 'settings': {'index': {'order ': {'ptype': 'String', 'required': False},
                        'page ': {'ptype': 'String', 'required': False},
                        'per_page ': {'ptype': 'String', 'required': False},
                        'search ': {'ptype': 'String', 'required': False}},
              'show': {'id ': {'ptype': 'String', 'required': True}},
              'update': {'id ': {'ptype': 'String', 'required': True},
                         'setting ': {'ptype': 'Hash', 'required': True},
                         'setting[value] ': {'ptype': 'String',
                                             'required': False}}},
 'smart_proxies': {'create': {'smart_proxy ': {'ptype': 'Hash',
                                               'required': True},
                              'smart_proxy[name] ': {'ptype': 'String',
                                                     'required': True},
                              'smart_proxy[url] ': {'ptype': 'String',
                                                    'required': True}},
                   'destroy': {'id ': {'ptype': 'String', 'required': True}},
                   'index': {'page ': {'ptype': 'String', 'required': False},
                             'per_page ': {'ptype': 'String',
                                           'required': False},
                             'type ': {'ptype': 'String', 'required': False}},
                   'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                    'required': True}},
                   'update': {'id ': {'ptype': 'String', 'required': True},
                              'smart_proxy ': {'ptype': 'Hash',
                                               'required': True},
                              'smart_proxy[name] ': {'ptype': 'String',
                                                     'required': False},
                              'smart_proxy[url] ': {'ptype': 'String',
                                                    'required': False}}},
 'subnets': {'create': {'subnet ': {'ptype': 'Hash', 'required': True},
                        'subnet[dhcp_id] ': {'ptype': 'number.',
                                             'required': False},
                        'subnet[dns_id] ': {'ptype': 'number.',
                                            'required': False},
                        'subnet[dns_primary] ': {'ptype': 'String',
                                                 'required': False},
                        'subnet[dns_secondary] ': {'ptype': 'String',
                                                   'required': False},
                        'subnet[domain_ids] ': {'ptype': 'Array',
                                                'required': False},
                        'subnet[from] ': {'ptype': 'String',
                                          'required': False},
                        'subnet[gateway] ': {'ptype': 'String',
                                             'required': False},
                        'subnet[mask] ': {'ptype': 'String',
                                          'required': True},
                        'subnet[name] ': {'ptype': 'String',
                                          'required': True},
                        'subnet[network] ': {'ptype': 'String',
                                             'required': True},
                        'subnet[tftp_id] ': {'ptype': 'number.',
                                             'required': False},
                        'subnet[to] ': {'ptype': 'String',
                                        'required': False},
                        'subnet[vlanid] ': {'ptype': 'String',
                                            'required': False}},
             'destroy': {'id ': {'ptype': 'number.', 'required': True}},
             'index': {'order ': {'ptype': 'String', 'required': False},
                       'page ': {'ptype': 'String', 'required': False},
                       'per_page ': {'ptype': 'String', 'required': False},
                       'search ': {'ptype': 'String', 'required': False}},
             'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                              'required': True}},
             'update': {'id ': {'ptype': 'number.', 'required': True},
                        'subnet ': {'ptype': 'Hash', 'required': True},
                        'subnet[dhcp_id] ': {'ptype': 'number.',
                                             'required': False},
                        'subnet[dns_id] ': {'ptype': 'number.',
                                            'required': False},
                        'subnet[dns_primary] ': {'ptype': 'String',
                                                 'required': False},
                        'subnet[dns_secondary] ': {'ptype': 'String',
                                                   'required': False},
                        'subnet[domain_ids] ': {'ptype': 'Array',
                                                'required': False},
                        'subnet[from] ': {'ptype': 'String',
                                          'required': False},
                        'subnet[gateway] ': {'ptype': 'String',
                                             'required': False},
                        'subnet[mask] ': {'ptype': 'String',
                                          'required': False},
                        'subnet[name] ': {'ptype': 'String',
                                          'required': False},
                        'subnet[network] ': {'ptype': 'String',
                                             'required': False},
                        'subnet[tftp_id] ': {'ptype': 'number.',
                                             'required': False},
                        'subnet[to] ': {'ptype': 'String',
                                        'required': False},
                        'subnet[vlanid] ': {'ptype': 'String',
                                            'required': False}}},
 'template_kinds': {'index': {'page ': {'ptype': 'String',
                                        'required': False},
                              'per_page ': {'ptype': 'String',
                                            'required': False}}},
 'usergroups': {'create': {'usergroup ': {'ptype': 'Hash', 'required': True},
                           'usergroup[name] ': {'ptype': 'String',
                                                'required': True}},
                'destroy': {'id ': {'ptype': 'String', 'required': True}},
                'index': {'order ': {'ptype': 'String', 'required': False},
                          'page ': {'ptype': 'String', 'required': False},
                          'per_page ': {'ptype': 'String',
                                        'required': False},
                          'search ': {'ptype': 'String', 'required': False}},
                'show': {'id ': {'ptype': 'identifier, string from 1 to 128 characters containing only alphanumeric characters, space, underscore(_), hypen(-) with no leading or trailing space.',
                                 'required': True}},
                'update': {'id ': {'ptype': 'String', 'required': True},
                           'usergroup ': {'ptype': 'Hash', 'required': True},
                           'usergroup[name] ': {'ptype': 'String',
                                                'required': False}}},
 'users': {'create': {'user ': {'ptype': 'Hash', 'required': True},
                      'user[admin] ': {'ptype': "'true' or 'false'",
                                       'required': False},
                      'user[auth_source_id] ': {'ptype': 'Integer',
                                                'required': True},
                      'user[firstname] ': {'ptype': 'String',
                                           'required': False},
                      'user[lastname] ': {'ptype': 'String',
                                          'required': False},
                      'user[login] ': {'ptype': 'String', 'required': True},
                      'user[mail] ': {'ptype': 'String', 'required': True},
                      'user[password] ': {'ptype': 'String',
                                          'required': True}},
           'destroy': {'id ': {'ptype': 'String', 'required': True}},
           'index': {'order ': {'ptype': 'String', 'required': False},
                     'page ': {'ptype': 'String', 'required': False},
                     'per_page ': {'ptype': 'String', 'required': False},
                     'search ': {'ptype': 'String', 'required': False}},
           'show': {'id ': {'ptype': 'String', 'required': True}},
           'update': {'id ': {'ptype': 'String', 'required': True},
                      'user ': {'ptype': 'Hash', 'required': True},
                      'user[admin] ': {'ptype': "'true' or 'false'",
                                       'required': False},
                      'user[firstname] ': {'ptype': 'String',
                                           'required': False},
                      'user[lastname] ': {'ptype': 'String',
                                          'required': False},
                      'user[login] ': {'ptype': 'String', 'required': False},
                      'user[mail] ': {'ptype': 'String', 'required': False},
                      'user[password] ': {'ptype': 'String',
                                          'required': False}}}}