#!/usr/bin/env python
"""
    Several commonly used constants and conversion factors are offered
    by this module, such a pi, the speed of light, the Planck constant,
    the charge of an electron, k_Boltzmann, the atomic masses of carbon
    and oxygen, the mass of a nucleon, one angstrom in meter, and one
    bar in Pascal.
    Source: CODATA2010
"""
#    Copyright 2009-2013 Max J. Hoffmann (mjhoffmann@gmail.com)
#    This file is part of kmos.
#
#    kmos is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    kmos is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with kmos.  If not, see <http://www.gnu.org/licenses/>.
keys = ['pi', 'c', 'h', 'hbar', 'eV', 'kboltzmann',
        'umass', 'angstrom', 'bar']

pi = 3.14159265358979323846  # approximately ...
c = 2.99792458e8  # m/s
h = 6.62606957e-34  # J s
hbar = 1.054571726e-34  # J s
eV = 1.602176565e-19  # C
kboltzmann = 1.3806488e-23  # J K
umass = 1.660538921e-27  # kg atomic mass
angstrom = 1.E-10  # m
bar = 1.E5  # kg / m s^2
