/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GenericSASLBindRequest
extends SASLBindRequest {
    private static final long serialVersionUID = 7740968332104559230L;
    private final ASN1OctetString credentials;
    private final String bindDN;
    private final String mechanism;

    public GenericSASLBindRequest(String bindDN, String mechanism, ASN1OctetString credentials, Control ... controls) {
        super(controls);
        Validator.ensureNotNull(mechanism);
        this.bindDN = bindDN;
        this.mechanism = mechanism;
        this.credentials = credentials;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public String getSASLMechanismName() {
        return this.mechanism;
    }

    public ASN1OctetString getCredentials() {
        return this.credentials;
    }

    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        return this.sendBindRequest(connection, this.bindDN, this.credentials, this.getControls(), this.getResponseTimeoutMillis(connection));
    }

    public GenericSASLBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public GenericSASLBindRequest duplicate(Control[] controls) {
        return new GenericSASLBindRequest(this.bindDN, this.mechanism, this.credentials, controls);
    }

    public void toString(StringBuilder buffer) {
        Control[] controls;
        buffer.append("GenericSASLBindRequest(mechanism='");
        buffer.append(this.mechanism);
        buffer.append('\'');
        if (this.bindDN != null) {
            buffer.append(", bindDN='");
            buffer.append(this.bindDN);
            buffer.append('\'');
        }
        if (this.credentials != null) {
            buffer.append(", credentials=byte[");
            buffer.append(this.credentials.getValueLength());
            buffer.append(']');
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

