/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CannedResponseRequestHandler
extends LDAPListenerRequestHandler
implements Serializable {
    private static final long serialVersionUID = 6199105854736880833L;
    private final AddResponseProtocolOp addResponseProtocolOp;
    private final BindResponseProtocolOp bindResponseProtocolOp;
    private final CompareResponseProtocolOp compareResponseProtocolOp;
    private final DeleteResponseProtocolOp deleteResponseProtocolOp;
    private final ExtendedResponseProtocolOp extendedResponseProtocolOp;
    private final ModifyResponseProtocolOp modifyResponseProtocolOp;
    private final ModifyDNResponseProtocolOp modifyDNResponseProtocolOp;
    private final SearchResultDoneProtocolOp searchResultDoneProtocolOp;

    public CannedResponseRequestHandler() {
        this(ResultCode.SUCCESS, null, null, null);
    }

    public CannedResponseRequestHandler(ResultCode resultCode, String matchedDN, String diagnosticMessage, List<String> referralURLs) {
        Validator.ensureNotNull(resultCode);
        int rc = resultCode.intValue();
        this.addResponseProtocolOp = new AddResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.bindResponseProtocolOp = new BindResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs, null);
        this.compareResponseProtocolOp = new CompareResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.deleteResponseProtocolOp = new DeleteResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.extendedResponseProtocolOp = new ExtendedResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs, null, null);
        this.modifyResponseProtocolOp = new ModifyResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.modifyDNResponseProtocolOp = new ModifyDNResponseProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
        this.searchResultDoneProtocolOp = new SearchResultDoneProtocolOp(rc, matchedDN, diagnosticMessage, referralURLs);
    }

    @Override
    public CannedResponseRequestHandler newInstance(LDAPListenerClientConnection connection) throws LDAPException {
        return this;
    }

    @Override
    public LDAPMessage processAddRequest(int messageID, AddRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.addResponseProtocolOp, Collections.<Control>emptyList());
    }

    @Override
    public LDAPMessage processBindRequest(int messageID, BindRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.bindResponseProtocolOp, Collections.<Control>emptyList());
    }

    @Override
    public LDAPMessage processCompareRequest(int messageID, CompareRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.compareResponseProtocolOp, Collections.<Control>emptyList());
    }

    @Override
    public LDAPMessage processDeleteRequest(int messageID, DeleteRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.deleteResponseProtocolOp, Collections.<Control>emptyList());
    }

    @Override
    public LDAPMessage processExtendedRequest(int messageID, ExtendedRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.extendedResponseProtocolOp, Collections.<Control>emptyList());
    }

    @Override
    public LDAPMessage processModifyRequest(int messageID, ModifyRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.modifyResponseProtocolOp, Collections.<Control>emptyList());
    }

    @Override
    public LDAPMessage processModifyDNRequest(int messageID, ModifyDNRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.modifyDNResponseProtocolOp, Collections.<Control>emptyList());
    }

    @Override
    public LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls) {
        return new LDAPMessage(messageID, (ProtocolOp)this.searchResultDoneProtocolOp, Collections.<Control>emptyList());
    }
}

