/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.UtilityMessages;
import com.unboundid.util.ValuePatternComponent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

final class FileValuePatternComponent
extends ValuePatternComponent {
    private static final long serialVersionUID = 2773328295435703361L;
    private final String[] lines;
    private final Random seedRandom;
    private final ThreadLocal<Random> random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileValuePatternComponent(String path, long seed) throws IOException {
        this.seedRandom = new Random(seed);
        this.random = new ThreadLocal();
        ArrayList<String> lineList = new ArrayList<String>(100);
        BufferedReader reader = new BufferedReader(new FileReader(path));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lineList.add(line);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        if (lineList.isEmpty()) {
            throw new IOException(UtilityMessages.ERR_VALUE_PATTERN_COMPONENT_EMPTY_FILE.get());
        }
        this.lines = new String[lineList.size()];
        lineList.toArray(this.lines);
    }

    void append(StringBuilder buffer) {
        Random r = this.random.get();
        if (r == null) {
            r = new Random(this.seedRandom.nextLong());
            this.random.set(r);
        }
        buffer.append(this.lines[r.nextInt(this.lines.length)]);
    }

    boolean supportsBackReference() {
        return true;
    }
}

