/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPControl;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPEntry;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPException;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPReferralException;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class LDAPSearchResults
implements Enumeration<Object>,
AsyncSearchResultListener {
    private static final long serialVersionUID = 7884355145560496230L;
    private final AtomicBoolean searchDone;
    private final AtomicInteger count;
    private final AtomicReference<Control[]> lastControls;
    private final AtomicReference<Object> nextResult;
    private final AtomicReference<SearchResult> searchResult;
    private final long maxWaitTime;
    private final LinkedBlockingQueue<Object> resultQueue;

    public LDAPSearchResults() {
        this(0L);
    }

    public LDAPSearchResults(long maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
        this.searchDone = new AtomicBoolean(false);
        this.count = new AtomicInteger(0);
        this.lastControls = new AtomicReference();
        this.nextResult = new AtomicReference();
        this.searchResult = new AtomicReference();
        this.resultQueue = new LinkedBlockingQueue(50);
    }

    private Object nextObject() {
        Object o = this.nextResult.get();
        if (o != null) {
            return o;
        }
        o = this.resultQueue.poll();
        if (o != null) {
            this.nextResult.set(o);
            return o;
        }
        if (this.searchDone.get()) {
            return null;
        }
        try {
            if (this.maxWaitTime > 0L) {
                o = this.resultQueue.poll(this.maxWaitTime, TimeUnit.MILLISECONDS);
                if (o == null) {
                    o = new SearchResult(-1, ResultCode.TIMEOUT, null, null, null, 0, 0, null);
                    this.count.incrementAndGet();
                }
            } else {
                o = this.resultQueue.take();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            o = new SearchResult(-1, ResultCode.USER_CANCELED, null, null, null, 0, 0, null);
            this.count.incrementAndGet();
        }
        this.nextResult.set(o);
        return o;
    }

    @Override
    public boolean hasMoreElements() {
        SearchResult r;
        Object o = this.nextObject();
        if (o == null) {
            return false;
        }
        if (o instanceof SearchResult && (r = (SearchResult)o).getResultCode().equals(ResultCode.SUCCESS)) {
            this.lastControls.set(r.getResponseControls());
            this.searchDone.set(true);
            this.nextResult.set(null);
            return false;
        }
        return true;
    }

    @Override
    public Object nextElement() throws NoSuchElementException {
        Object o = this.nextObject();
        if (o == null) {
            throw new NoSuchElementException();
        }
        this.nextResult.set(null);
        this.count.decrementAndGet();
        if (o instanceof SearchResultEntry) {
            SearchResultEntry e = (SearchResultEntry)o;
            this.lastControls.set(e.getControls());
            return new LDAPEntry(e);
        }
        if (o instanceof SearchResultReference) {
            SearchResultReference r = (SearchResultReference)o;
            this.lastControls.set(r.getControls());
            return new LDAPReferralException(r);
        }
        SearchResult r = (SearchResult)o;
        this.searchDone.set(true);
        this.nextResult.set(null);
        this.lastControls.set(r.getResponseControls());
        return new LDAPException(r.getDiagnosticMessage(), r.getResultCode().intValue(), r.getDiagnosticMessage(), r.getMatchedDN());
    }

    public LDAPEntry next() throws LDAPException {
        if (!this.hasMoreElements()) {
            throw new LDAPException(null, 94);
        }
        Object o = this.nextElement();
        if (o instanceof LDAPEntry) {
            return (LDAPEntry)o;
        }
        throw (LDAPException)o;
    }

    public int getCount() {
        return this.count.get();
    }

    public LDAPControl[] getResponseControls() {
        Control[] controls = this.lastControls.get();
        if (controls == null || controls.length == 0) {
            return null;
        }
        return LDAPControl.toLDAPControls(controls);
    }

    @Override
    @InternalUseOnly
    public void searchEntryReturned(SearchResultEntry searchEntry) {
        if (this.searchDone.get()) {
            return;
        }
        try {
            this.resultQueue.put(searchEntry);
            this.count.incrementAndGet();
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.searchDone.set(true);
        }
    }

    @Override
    @InternalUseOnly
    public void searchReferenceReturned(SearchResultReference searchReference) {
        if (this.searchDone.get()) {
            return;
        }
        try {
            this.resultQueue.put(searchReference);
            this.count.incrementAndGet();
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.searchDone.set(true);
        }
    }

    @Override
    @InternalUseOnly
    public void searchResultReceived(AsyncRequestID requestID, SearchResult searchResult) {
        if (this.searchDone.get()) {
            return;
        }
        try {
            this.resultQueue.put(searchResult);
            if (!searchResult.getResultCode().equals(ResultCode.SUCCESS)) {
                this.count.incrementAndGet();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.searchDone.set(true);
        }
    }
}

