# -*- coding: utf-8 -*-
from getopt import getopt


def parse_argv(argv):
    """
        | Getting task name and parameters sys.argv[1:]
        | return (flags, task, args, kwargs)
    """
    flags = {
        "verbose": False,
        "help": False
    }

    options, arguments = getopt(argv[1:], "", ["verbose", "help"])

    for key, value in options:
        flags[key[2:]] = value or True

    task, args, kwargs = None, [], {}
    if not flags["help"]:
        key = None
        for e in arguments:
            if e[:2] == "--":
                key = e[2:]
            elif key:
                kwargs[key] = e
            else:
                args.append(e)

        task, args = args[0], args[1:]
    return flags, task, args, kwargs
