# -*- coding: utf-8 -*-
import yaml
import logging

from files_manager import FilesManager
from tasks_manager import TasksManager

class Pake(object):
    """
        | Compozit object, contains
        | FilesManager instance
        | TasksManager instance
    """
    log = logging.getLogger("pake.runner")

    def __init__(self):
        self._files_manager = FilesManager()
        self._tasks_manager = TasksManager()

    def search_tasks(self):
        """
            Proxy to :py:meth:`pake.runner.files_manager.FilesManager.search_tasks`
        """
        self._files_manager.search_tasks()

    def add_task(self, proc):
        """
            | Function-decorator
            |     call :py:meth:`pake.runner.tasks_manager.TasksManager.add_task`
            |     return decorated function
        """
        self._tasks_manager.add_task(proc)
        return proc

    def run(self, key, *args, **kwargs):
        """
            log.info and call :py:meth:`pake.runner.tasks_manager.TasksManager.run`
        """
        self.log.info("Pake.run \"{}\", args: {}, kwargs: {}".format(key, args, kwargs))
        return self._tasks_manager.run(key, *args, **kwargs)

    def overview(self):
        """
            Proxy to :py:meth:`pake.runner.tasks_manager.TasksManager.overview`
        """
        return self._tasks_manager.overview()
