# -*- coding: utf-8 -*-
from contextlib import contextmanager

@contextmanager
def sudo(name=""):
    """
        | Context manager for sugar like
        | with sudo():
        |     rm("-rf /")
    """
    Sudo.set(name)
    try:
        yield Sudo
    finally:
        Sudo.reset()


class SudoClass(object):
    """
        Object which user context manager and ShellCmd
    """
    _sudo = False
    _user = ""

    def __call__(self):
        result = []
        if self._sudo and self._user:
            result = ["sudo", "-u", self._user]
        elif self._sudo:
            result = ["sudo"]
        return result

    def set(self, user):
        """
            Call in header of context manager block
        """
        self._sudo = True
        self._user = user

    def reset(self):
        """
            Call in the out of context manager block
        """
        self._sudo = False
        self._user = ""

Sudo = SudoClass()
